/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import cz.dd4j.utils.csv.CSV;
import java.util.List;

@AutoConfig
public class Clever05Agent
extends PDDLAgentBase {
    @Configurable
    protected int dangerThreshold = 2;
    @Configurable
    protected int safeThreshold = 3;
    protected boolean destroyingDanger = false;
    protected List<PDDLAction> currentPlan;
    private boolean reactiveActionTaken;
    private boolean reactiveEscape = false;
    protected int reactiveActions = 0;
    private Monster dangerousMonster = null;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
    }

    @Override
    public void reset() {
        super.reset();
        this.destroyingDanger = false;
    }

    protected boolean shouldReplan() {
        if (this.reactiveActionTaken) {
            return true;
        }
        if (this.currentPlan == null || this.currentPlan.isEmpty()) {
            return true;
        }
        PDDLAction action = this.currentPlan.get(0);
        return !this.actionValidator.isValid((Entity)this.hero, this.translateAction(action));
    }

    private Command getBestReactiveAction() {
        ++this.reactiveActions;
        this.reactiveActionTaken = true;
        List availableActions = this.actionsGenerator.generateFor((Entity)this.hero);
        Command selectedAction = null;
        int bestVal = Integer.MIN_VALUE;
        for (Command c : availableActions) {
            int val = this.evaluateCommand(c);
            if (val <= bestVal) continue;
            selectedAction = c;
            bestVal = val;
        }
        return selectedAction;
    }

    @Override
    public Command act() {
        int dng = this.dang(this.hero.atRoom);
        if (dng == 0) {
            return null;
        }
        if (this.destroyingDanger && this.currentPlan != null) {
            if (this.currentPlan.isEmpty()) {
                this.destroyingDanger = false;
            } else {
                Command act = this.translateAction(this.currentPlan.remove(0));
                if (act.isType(EAction.MOVE) && ((Room)act.target).monster != null && this.hero.hand == null) {
                    this.reactiveEscape = true;
                    this.destroyingDanger = false;
                    this.dangerousMonster = this.getClosestMonster((Room)act.target);
                } else {
                    return act;
                }
            }
        }
        if (dng <= this.dangerThreshold && this.hero.atRoom.feature == null) {
            this.reactiveEscape = true;
            this.destroyingDanger = false;
            this.dangerousMonster = this.getClosestMonster(this.hero.atRoom);
        }
        if (this.reactiveEscape && dng >= this.safeThreshold) {
            this.reactiveEscape = false;
            this.currentPlan = this.plan(String.format("(and (alive)(has_sword)(not(monster_at %s)))", this.dangerousMonster.atRoom.id.name));
            this.dangerousMonster = null;
            if (this.currentPlan != null && !this.currentPlan.isEmpty()) {
                this.destroyingDanger = true;
                this.reactiveActionTaken = false;
                return this.translateAction(this.currentPlan.remove(0));
            }
        }
        if (this.reactiveEscape) {
            return this.getBestReactiveAction();
        }
        if (this.shouldReplan()) {
            this.currentPlan = this.plan();
            if (this.currentPlan == null) {
                return this.getBestReactiveAction();
            }
        }
        this.reactiveActionTaken = false;
        PDDLAction currentAction = this.currentPlan.remove(0);
        return this.translateAction(currentAction);
    }

    private int evaluateCommand(Command cmd) {
        return this.dangAfterAction(cmd);
    }

    @Override
    public List<String> getCSVHeaders() {
        List<String> headers = super.getCSVHeaders();
        headers.add("reactive_steps");
        return headers;
    }

    @Override
    public CSV.CSVRow getCSVRow() {
        CSV.CSVRow row = super.getCSVRow();
        row.add("reactive_steps", (Object)this.reactiveActions);
        return row;
    }
}

