/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.util.List;

@AutoConfig
public class Clever04Agent
extends PDDLAgentBase {
    @Configurable
    protected int threshold = 2;
    protected List<PDDLAction> currentPlan;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
    }

    protected boolean shouldReplan() {
        if (this.currentPlan == null || this.currentPlan.isEmpty()) {
            return true;
        }
        PDDLAction action = this.currentPlan.get(0);
        return !this.actionValidator.isValid((Entity)this.hero, this.translateAction(action));
    }

    @Override
    public Command act() {
        List<PDDLAction> safePlan;
        if (this.dang(this.hero.atRoom) == 0) {
            return null;
        }
        if (this.shouldReplan()) {
            this.currentPlan = this.plan();
        }
        if (this.currentPlan == null) {
            return null;
        }
        PDDLAction currentAction = this.currentPlan.remove(0);
        Command cmd = this.translateAction(currentAction);
        if (cmd == null) {
            return null;
        }
        int dng = this.dangAfterAction(cmd);
        if (dng <= this.threshold) {
            if (cmd.isType(EAction.MOVE) && ((Room)cmd.target).feature != null) {
                return cmd;
            }
            safePlan = null;
            if (cmd.isType(EAction.MOVE)) {
                Monster m = this.getClosestMonster((Room)cmd.target);
                safePlan = this.plan("(and (alive)(has_sword)(not(monster_at " + m.atRoom.id.toString() + ")))");
            } else {
                Monster m = this.getClosestMonster(this.hero.atRoom);
                safePlan = this.plan("(and (alive)(has_sword)(not(monster_at " + m.atRoom.id.toString() + ")))");
            }
        } else {
            return cmd;
        }
        this.currentPlan = safePlan;
        if (this.currentPlan == null) {
            return null;
        }
        currentAction = this.currentPlan.remove(0);
        return this.translateAction(currentAction);
    }
}

