/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.util.List;

@AutoConfig
public class Clever02Agent
extends PDDLAgentBase {
    @Configurable
    protected int threshold = 2;
    protected List<PDDLAction> currentPlan;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
    }

    protected boolean shouldReplan() {
        if (this.currentPlan == null || this.currentPlan.isEmpty()) {
            return true;
        }
        PDDLAction action = this.currentPlan.get(0);
        return !this.actionValidator.isValid((Entity)this.hero, this.translateAction(action));
    }

    @Override
    public Command act() {
        int dng = this.dang(this.hero.atRoom);
        if (dng == 0) {
            return null;
        }
        if (dng <= this.threshold && this.hero.atRoom.feature == null) {
            Monster m = this.getClosestMonster(this.hero.atRoom);
            this.currentPlan = this.plan(String.format("(and (alive)(has_sword)(not(monster_at %s)))", m.atRoom.id.name));
        } else if (this.shouldReplan()) {
            this.currentPlan = this.plan();
        }
        if (this.currentPlan == null) {
            return null;
        }
        PDDLAction currentAction = this.currentPlan.remove(0);
        return this.translateAction(currentAction);
    }
}

