/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

class CEExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final PoshPlan plan;
    private final Competence competence;
    private final CompetenceElement choice;
    private PrimitiveCall actionCall;
    private String name;
    private SenseListExecutor<CompetenceElement> trigger;
    private int retries = 0;
    private int maxRetries;
    private boolean actionCalled = false;

    CEExecutor(PoshPlan plan, Competence competence, CompetenceElement choice, LapPath choicePath, VariableContext ctx, EngineLog log) {
        super(choicePath, ctx, log);
        assert (choicePath.traversePath(plan) == choice);
        assert (choicePath.subpath(0, choicePath.length() - 1).traversePath(plan) == competence);
        this.plan = plan;
        this.competence = competence;
        this.choice = choice;
        this.name = choice.getName();
        this.trigger = new SenseListExecutor<CompetenceElement>(choice.getTrigger(), choicePath, ctx, log);
        this.maxRetries = choice.getRetries();
        this.actionCall = choice.getAction().getActionCall();
    }

    private LapPath createChoiceActionPath() {
        return this.path.concat(LapType.ACTION, 0);
    }

    private StackElement createActionExecutor(PrimitiveCall actionCall) {
        LapPath choiceActionPath = this.createChoiceActionPath();
        return this.getElement(this.plan, actionCall, choiceActionPath);
    }

    TriggerResult isReady(IWorkExecutor workExecuter) {
        this.engineLog.fine("isReady? " + this.retries + "/" + this.maxRetries);
        TriggerResult result = this.maxRetries == -1 || this.retries < this.maxRetries ? this.trigger.fire(workExecuter, true) : new TriggerResult(false);
        return result;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        this.engineLog.pathReached(this.path);
        if (this.actionCalled) {
            this.actionCalled = false;
            return new FireResult(FireResult.Type.SURFACE_CONTINUE);
        }
        ++this.retries;
        this.actionCalled = true;
        return new FireResult(FireResult.Type.FOLLOW, this.createActionExecutor(this.actionCall));
    }

    String getName() {
        return this.name;
    }
}

