/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.IChainLink;
import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.ReferenceChainLink;
import cz.cuni.amis.pogamut.sposh.elements.ReferenceNodeChainLink;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class LapChain
implements PoshElementListener {
    private List<IChainLink> links;
    private final Set<ILapChainListener> listeners = new HashSet<ILapChainListener>();

    public LapChain() {
        this.links = new LinkedList<IChainLink>();
    }

    public static LapChain fromPath(PoshPlan plan, LapPath path) {
        LapChain chain = new LapChain();
        Iterator<LapPath.Link> iterator = path.iterator();
        while (iterator.hasNext()) {
            LapPath.Link nodeLink = iterator.next();
            int index = path.getLinkIndex(nodeLink) + 1;
            LapPath nodePath = path.subpath(0, index);
            Object node = nodePath.traversePath(plan);
            if (node instanceof TriggeredAction) {
                TriggeredAction reference = (TriggeredAction)node;
                chain = LapChain.processReference(plan, path, chain, iterator, reference);
                continue;
            }
            if (!(node instanceof Sense)) continue;
            chain = chain.derive((Sense)node);
        }
        return chain;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LapChain processReference(PoshPlan plan, LapPath path, LapChain chain, Iterator<LapPath.Link> iterator, TriggeredAction reference) {
        if (!iterator.hasNext()) return chain.derive(reference);
        LapPath.Link referencedNodeLink = iterator.next();
        LapPath processedPath = path.subpath(0, path.getLinkIndex(referencedNodeLink) + 1);
        Object referencedNode = processedPath.traversePath(plan);
        if (referencedNode instanceof Competence) {
            return chain.derive(reference, (Competence)referencedNode);
        }
        if (referencedNode instanceof ActionPattern) {
            return chain.derive(reference, (ActionPattern)referencedNode);
        }
        if (!(referencedNode instanceof Adopt)) throw new IllegalStateException("Node " + referencedNodeLink + " is not a referenced node.");
        return chain.derive(reference, (Adopt)referencedNode);
    }

    public LapPath toPath() {
        IChainLink link;
        if (this.links.isEmpty()) {
            return LapPath.DRIVE_COLLECTION_PATH;
        }
        LapPath path = LapPath.PLAN_PATH;
        Iterator<IChainLink> it = this.links.iterator();
        do {
            link = it.next();
            LapPath linkPath = LapPath.getLinkPath(link.getReference());
            path = path.concat(linkPath);
        } while (it.hasNext());
        PoshElement referencedNode = link.getReferencedNode();
        if (referencedNode != null) {
            path = path.concat(referencedNode.getType(), referencedNode.getId());
        }
        return path;
    }

    private LapChain(LapChain chain, IChainLink link) {
        this.links = new LinkedList<IChainLink>(chain.links);
        this.links.add(link);
    }

    public void register() {
        for (IChainLink link : this.links) {
            link.register(this);
        }
    }

    public void unregister() {
        for (IChainLink link : this.links) {
            link.unregister(this);
        }
    }

    public <REFERENCED_NODE extends PoshElement> LapChain derive(TriggeredAction action, REFERENCED_NODE referencedNode) {
        assert (action.getName().equals(((INamedElement)((Object)referencedNode)).getName()));
        return new LapChain(this, new ReferenceNodeChainLink<REFERENCED_NODE>(referencedNode, action));
    }

    public <REFERENCE extends PoshElement> LapChain derive(REFERENCE reference) {
        return new LapChain(this, new ReferenceChainLink<REFERENCE>(reference));
    }

    public LapChain subchain(int beginIndex, int endIndex) {
        LapChain subchain = new LapChain();
        for (IChainLink link : this.links.subList(beginIndex, endIndex)) {
            subchain = new LapChain(subchain, link);
        }
        return subchain;
    }

    public int size() {
        return this.links.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Chain{");
        boolean first = true;
        for (IChainLink link : this.links) {
            if (!first) {
                sb.append(',');
            }
            sb.append(link.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    public VariableContext createContext() {
        VariableContext ctx = new VariableContext();
        for (IChainLink link : this.links) {
            ctx = new VariableContext(ctx, link.getArgs(), link.getParams());
        }
        return ctx;
    }

    public void childElementAdded(PoshElement parent, PoshElement child) {
    }

    public void childElementMoved(PoshElement parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public void childElementRemoved(PoshElement parent, PoshElement child, int removedChildPosition) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.emitLinkChanged();
    }

    public boolean addChainListener(ILapChainListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeChainListener(ILapChainListener listener) {
        return this.listeners.remove(listener);
    }

    private void emitLinkChanged() {
        ILapChainListener[] listenersArray;
        for (ILapChainListener listener : listenersArray = this.listeners.toArray(new ILapChainListener[this.listeners.size()])) {
            listener.notifyLinkChanged();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LapChain other = (LapChain)obj;
        return this.links == other.links || this.links != null && this.links.equals(other.links);
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.links != null ? this.links.hashCode() : 0);
        return hash;
    }
}

