/* Generated By:JavaCC: Do not edit this line. PoshParser.java */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.shady.ArgString;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PoshParser implements PoshParserConstants {
    final static class Packet<FIRST, SECOND> {
        Packet(FIRST first, SECOND second) {
            this.first = first;
            this.second = second;
        }
        public FIRST first;
        public SECOND second;
    }

    /**
     * Take the token COMMENT and unescape its content.
     */
    private String unescape(String comment)  throws ParseException {
        // comment token must have at least starting and ending double quote
        int commentLength = comment.length();
        if (commentLength < 2)
            throw new ParseException();
        if (comment.charAt(0) != '"' || comment.charAt(commentLength - 1) != '"')
            throw new ParseException();

        String commentContent = comment.substring(1, commentLength - 1);
        // ArgString throws different ParseException that this parser.
        try {
            return ArgString.unescape(commentContent);
        } catch (Exception ex) {
            throw new ParseException(ex.getMessage());
        }
    }

/**
 * FIXME: According to official grammar, plan can consists only from single
 * competence or action pattern. Sorry, but I don't allow this for now.
 * plan ::= "(" [ "(" <docstring> ]
                ( "(" <competence> | <action-pattern> )*
                  "(" <drive-collection>
                ( "(" <competence> | <action-pattern> )* ")" 
 */
  final public PoshPlan parsePlan() throws ParseException {
        PoshPlan plan = LapElementsFactory.createPlan();
    jj_consume_token(LBRACE);
    jj_consume_token(LBRACE);
    planFirstElement(plan);
    jj_consume_token(0);
                                                        {if (true) return plan;}
    throw new Error("Missing return statement in function");
  }

/**
 * [ "(" <docstring> ]
 * Part of plan rule. 
 */
  final public void planFirstElement(PoshPlan plan) throws ParseException {
        ActionPattern ap;
        Competence c;
        DriveCollection dc;
        Adopt ad;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOCUMENTATION:
      docString(plan);
      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case AP:
      ap = actionPattern();
            plan.addActionPattern(ap);
            // ex.currentToken = token;

      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case COMPETENCE:
      c = competence();
            plan.addCompetence(c);
            // ex.currentToken = token;

      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case AD:
      ad = adapt();
                        plan.addAdopt(ad);
                        // ex.currentToken = token;

      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case DC:
      driveCollection(plan.getDriveCollection());
      planSecondHalf(plan);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * First half of plan rule.
 * ( "(" <competence> | <action-pattern> )*
 */
  final public void planFirstHalf(PoshPlan plan) throws ParseException {
        ActionPattern ap;
        Competence c;
        Adopt ad;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AP:
      ap = actionPattern();
            try {
                plan.addActionPattern(ap);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case COMPETENCE:
      c = competence();
            try {
                plan.addCompetence(c);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case AD:
      ad = adapt();
                        try {
                plan.addAdopt(ad);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      jj_consume_token(LBRACE);
      planFirstHalf(plan);
      break;
    case DC:
      driveCollection(plan.getDriveCollection());
      planSecondHalf(plan);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * ( "(" <competence> | <action-pattern> )* 
 *  Part of plan() rule
 */
  final public void planSecondHalf(PoshPlan plan) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      planSecondHalfElements(plan);
      break;
    case RBRACE:
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * ( <competence> | <action-pattern> ) planSecondHalf(plan)
 */
  final public void planSecondHalfElements(PoshPlan plan) throws ParseException {
        ActionPattern ap;
        Competence c;
        Adopt ad;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AP:
      ap = actionPattern();
            try {
                plan.addActionPattern(ap);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      planSecondHalf(plan);
      break;
    case COMPETENCE:
      c = competence();
            try {
                plan.addCompetence(c);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      planSecondHalf(plan);
      break;
    case AD:
      ad = adapt();
            try {
                plan.addAdopt(ad);
            } catch (ParseException ex) {
                ex.currentToken = token;
                {if (true) throw ex;}
            }
      planSecondHalf(plan);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * docstring ::= DOCUMENTATION COMMENT COMMENT COMMENT ")" 
 */
  final public void docString(PoshPlan plan) throws ParseException {
    Token name, author, info;
    jj_consume_token(DOCUMENTATION);
    name = jj_consume_token(COMMENT);
                     plan.setName(unescape(name.toString()));
    author = jj_consume_token(COMMENT);
                       plan.setAuthor(unescape(author.toString()));
    info = jj_consume_token(COMMENT);
                     plan.setInfo(unescape(info.toString()));
    jj_consume_token(RBRACE);
  }

/**
 * Take passed drive collection and put the data (name, drives) into it.
 * <pre>
 * driveCollection() :: "DC" <name> [ <goal> ] "(" "drives" ( "(" <drive-element>+ ")" )+ ")" ")"
 * </pre>
 * XXX: It has extra braces around <drive-element>, remove them
 */
  final public void driveCollection(DriveCollection dc) throws ParseException {
    Token name;
    DriveElement drive;
    FormalParameters formalParameters = new FormalParameters();
    jj_consume_token(DC);
    name = jj_consume_token(NAME);
                       dc.setName(name.toString());
    driveCollectionGoal(dc, formalParameters);
    label_1:
    while (true) {
      jj_consume_token(LBRACE);
      label_2:
      while (true) {
        drive = driveElement(formalParameters);
                                                     dc.addDrive(drive);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_2;
        }
      }
      jj_consume_token(RBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(RBRACE);
    jj_consume_token(RBRACE);
  }

/**
 * Process goal of DC (if exists).
 * ( NIL | "(" <goal> | ) "(" <DRIVES>
 * Part of driveCollection() rule.
 */
  final public void driveCollectionGoal(DriveCollection dc, FormalParameters formalParameters) throws ParseException {
    List<Sense> goalSenses;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GOAL:
      goalSenses = goal(formalParameters);
                                           dc.getGoal().addAll(goalSenses);
      jj_consume_token(LBRACE);
      jj_consume_token(DRIVES);
      break;
    case DRIVES:
      jj_consume_token(DRIVES);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Process goal sense and return them.
 * goal ::= GOAL <senses> ")"
 */
  final public List<Sense> goal(FormalParameters formalParameters) throws ParseException {
    List<Sense> senses;
    jj_consume_token(GOAL);
    senses = senses(formalParameters);
    jj_consume_token(RBRACE);
     {if (true) return senses;}
    throw new Error("Missing return statement in function");
  }

/**
 * Create a drive and return it.
 * <pre>
 * drive-element ::= "(" NAME ( NIL | "(" <trigger> | ) NAME ( NIL | "(" <freq> | ) <opt-comment> ")"
 * </pre>
 */
  final public DriveElement driveElement(FormalParameters formalParameters) throws ParseException {
    Token name;
    Packet<Arguments, Freq> packet;
    Token actionName;
    List<Sense> triggerSenses;
    String comment;
    jj_consume_token(LBRACE);
    name = jj_consume_token(NAME);
    triggerSenses = driveElementTrigger(formalParameters);
    actionName = jj_consume_token(NAME);
    packet = driveElementActionFreq(formalParameters);
    comment = optComment();
    jj_consume_token(RBRACE);
            {if (true) return LapElementsFactory.createDriveElement(name.toString(), triggerSenses, new PrimitiveCall(actionName.toString(), packet.first), packet.second, comment);}
    throw new Error("Missing return statement in function");
  }

/**
 * Nonterminal for possible arguments of the action call of the drive action and 
 * the frequency.
 * <code>
 * driveElementActionFreq:: ( <nil> | "(" ( <freq> | <args> <freq> ) | )
 * </code>
 * I should probably use lookahead of 2 or more, but I really need this fast 
 * for continuous syntax highlighting.  
 */
  final public Packet<Arguments, Freq> driveElementActionFreq(FormalParameters formalParameters) throws ParseException {
    Arguments arguments = new Arguments();
    Freq freq = Freq.INFINITE;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
            {if (true) return new Packet<Arguments, Freq>(arguments, freq);}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOURS:
      case MINUTES:
      case SECONDS:
      case HZ:
      case PM:
      case NONE:
        freq = freq();
                    {if (true) return new Packet<Arguments, Freq>(arguments, freq);}
        break;
      case NIL:
      case TRUE:
      case FALSE:
      case NUMFLOAT:
      case NUMINT:
      case ENUM_VALUE:
      case COMMENT:
      case VARIABLE:
        arguments = callParametersList(formalParameters);
        freq = driveElementFreq();
                    {if (true) return new Packet<Arguments, Freq>(arguments, freq);}
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[8] = jj_gen;
            {if (true) return new Packet<Arguments, Freq>(arguments, freq);}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Read trigger (list of senses) and return it.
 * <p/>
 * <code>( NIL | "(" <trigger> | ) </code>
 * Part of driveElement rule
 */
  final public List<Sense> driveElementTrigger(FormalParameters formalParameters) throws ParseException {
    List<Sense> senses;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
      {if (true) return Collections.<Sense>emptyList();}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      senses = trigger(formalParameters);
      {if (true) return senses;}
      break;
    default:
      jj_la1[9] = jj_gen;
      {if (true) return Collections.<Sense>emptyList();}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Get specified frequency. If no frequency specified, return {@link Freq#INFINITE}.
 * ( NIL | "(" <freq> | )
 * Part of driveElementRule
 */
  final public Freq driveElementFreq() throws ParseException {
    Freq _freq;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
      {if (true) return Freq.INFINITE;}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      _freq = freq();
     {if (true) return _freq;}
      break;
    default:
      jj_la1[10] = jj_gen;
     {if (true) return Freq.INFINITE;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * competence ::= C NAME ( NIL | "(" <time> | ) ( NIL | "(" <goal> | ) "(" ELEMENTS <competence-priorities> ")" <opt-comment> ")" 
 */
  final public Competence competence() throws ParseException {
        Token _name;
        FormalParameters params = new FormalParameters();
        List<CompetenceElement> competenceElements;
        String _comment="";
    jj_consume_token(COMPETENCE);
    _name = jj_consume_token(NAME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARS:
      params = parameters();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    jj_consume_token(ELEMENTS);
    competenceElements = competencePriorities(params);
    jj_consume_token(RBRACE);
    _comment = optComment();
    jj_consume_token(RBRACE);
                {if (true) return new Competence(_name.toString(), params, competenceElements);}
    throw new Error("Missing return statement in function");
  }

/**
 * Declare parameters in C or AP.
 * parameters:: "vars" "(" varDeclaration() ( "," varDeclaration() )* ")"
 */
  final public FormalParameters parameters() throws ParseException {
    FormalParameters.Parameter param = null;
    FormalParameters params = new FormalParameters();
    jj_consume_token(VARS);
    jj_consume_token(LBRACE);
    param = varDeclaration();
          params.add(param);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      param = varDeclaration();
          try {
            params.add(param);
          } catch (IllegalArgumentException ex) {
            ParseException parseException = new ParseException(ex.getMessage());
            parseException.currentToken = token;
            {if (true) throw parseException;}
          }
    }
    jj_consume_token(RBRACE);
         {if (true) return params;}
    throw new Error("Missing return statement in function");
  }

/**
 * varDeclare:: <VARIABLE> "=" value()
 */
  final public FormalParameters.Parameter varDeclaration() throws ParseException {
    Token variable = null;
    Object defaultValue = null;
    variable = jj_consume_token(VARIABLE);
    jj_consume_token(EQUAL_SIGN);
    defaultValue = value();
                                                   {if (true) return new FormalParameters.Parameter(variable.toString(), defaultValue);}
    throw new Error("Missing return statement in function");
  }

/**
 * ( NIL | "(" <time> | ) ( NIL | "(" <goal> | ) "(" ELEMENTS
 * Part of competence() rule, Really ugly, but it has to check 8 combinations.
 */
/*
TimeGoal competenceTimeGoal(FormalParameters formalParameters):
{
	TimeGoal tg = new TimeGoal();
}
{
    <NIL> tg.goal=competenceGoal(formalParameters) { return tg; }
|
    "(" ( 
			 		tg.time=time()   tg.goal=competenceGoal(formalParameters) { return tg;} 
			 | 
					<ELEMENTS> { return tg;}
		   | 
			    tg.goal=goal(formalParameters) "(" <ELEMENTS> { return tg;}
			 	 )
}*/

/**
 * ( NIL | "(" <goal> | ) "(" ELEMENTS
 * Part of competence() rule
 */
  final public List<Sense> competenceGoal(FormalParameters formalParameters) throws ParseException {
    List<Sense> goalSenses;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
      jj_consume_token(LBRACE);
      jj_consume_token(ELEMENTS);
                          {if (true) return Collections.<Sense>emptyList();}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GOAL:
        goalSenses = goal(formalParameters);
        break;
      case ELEMENTS:
        jj_consume_token(ELEMENTS);
                                                          {if (true) return Collections.<Sense>emptyList();}
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LBRACE);
      jj_consume_token(ELEMENTS);
                                                                                                                    {if (true) return goalSenses;}
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * competence-priorities ::= <competence-elements>+
 * competence-elements ::= "(" <competence-element>+ ")"
 *
 * => competence-priorities ::= ( "(" <competence-element>+ ")" )+.
 */
  final public List<CompetenceElement> competencePriorities(FormalParameters formalParameters) throws ParseException {
    CompetenceElement ce;
    List<CompetenceElement> result = new LinkedList<CompetenceElement>();
    label_4:
    while (true) {
      jj_consume_token(LBRACE);
      label_5:
      while (true) {
        ce = competenceElement(formalParameters);
                    result.add(ce);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_5;
        }
      }
      jj_consume_token(RBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_4;
      }
    }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * competence-element ::= "(" NAME [ "(" <trigger> ] NAME [ INTNUM ] <opt-comment> ")"
 */
  final public CompetenceElement competenceElement(FormalParameters formalParameters) throws ParseException {
        CompetenceElement _element;
        Token name= null;
        int retries;
        PrimitiveCall actionCall = null;
        List<Sense> triggerSenses = Collections.<Sense>emptyList();
        String comment;
    jj_consume_token(LBRACE);
    name = jj_consume_token(NAME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      triggerSenses = trigger(formalParameters);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    actionCall = senseCall(formalParameters);
    retries = optRetries();
    comment = optComment();
    jj_consume_token(RBRACE);
        {if (true) return new CompetenceElement(name.toString(), triggerSenses, actionCall, retries, comment);}
    throw new Error("Missing return statement in function");
  }

/**
 * Optional number of retries. If missing, return {@link CompetenceElement#INFINITE_RETRIES}.
 */
  final public int optRetries() throws ParseException {
    Token retries;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMINT:
      retries = jj_consume_token(NUMINT);
                       {if (true) return Integer.parseInt(retries.toString());}
      break;
    default:
      jj_la1[18] = jj_gen;
     {if (true) return CompetenceElement.INFINITE_RETRIES;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Optional comment, if no comment, return blank string.
 * opt-comment ::= COMMENT | 
 * @return Comment or if comment is missing, blank string.
 */
  final public String optComment() throws ParseException {
        Token _comment;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      _comment = jj_consume_token(COMMENT);
                {if (true) return unescape(_comment.toString());}
      break;
    default:
      jj_la1[19] = jj_gen;
     {if (true) return "";}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * action-pattern ::= AP NAME ( NIL | "(" <time> | ) "(" <action-pattern-elements> <opt-comment> ")"  
 */
  final public ActionPattern actionPattern() throws ParseException {
    ActionPattern ap;
    Token name;
    FormalParameters params = new FormalParameters();
    String comment;
    jj_consume_token(AP);
    name = jj_consume_token(NAME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARS:
      params = parameters();
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
        ap = LapElementsFactory.createActionPattern(name.toString(), params);
    jj_consume_token(LBRACE);
    actionPatternElements(ap, params);
    comment = optComment();
                                                                ap.setComment(comment);
    jj_consume_token(RBRACE);
     {if (true) return ap;}
    throw new Error("Missing return statement in function");
  }

/**
 * adapt ::= AD NAME [ <parameters> ] "(" "(" <goal> "(" <actionCall> ")"  
 */
  final public Adopt adapt() throws ParseException {
    Token name;
    FormalParameters params = new FormalParameters();
    List<Sense> exitCondition = Collections.<Sense>emptyList();
    PrimitiveCall actionCall = null;
    jj_consume_token(AD);
    name = jj_consume_token(NAME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARS:
      params = parameters();
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    jj_consume_token(LBRACE);
    exitCondition = goal(params);
    jj_consume_token(LBRACE);
    actionCall = senseCall(params);
    jj_consume_token(RBRACE);
    jj_consume_token(RBRACE);
    jj_consume_token(RBRACE);
        {if (true) return new Adopt(name.toString(), params, exitCondition, actionCall);}
    throw new Error("Missing return statement in function");
  }

/**
 * process actions of the AP and add them into the passed ap.
 * action-pattern-elements ::= ( <full-sense> | NAME )+ ")"
 * FIXME: full-sense is not implemented here, because I have no idea what to do with it.
 *        I have't even seen it used anywhere so it is doable for now.
 */
  final public void actionPatternElements(ActionPattern ap, FormalParameters formalParameters) throws ParseException {
    List<TriggeredAction> _actList = new LinkedList<TriggeredAction>();
    PrimitiveCall actionCall;
    label_6:
    while (true) {
      actionCall = senseCall(formalParameters);
            ap.addAction(LapElementsFactory.createAction(actionCall));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_6;
      }
    }
    jj_consume_token(RBRACE);
  }

/**
 * time ::= <time-unit> <numfloat> ")" 
 */
  final public SolTime time() throws ParseException {
     SolTime.TimeUnits _units;
        Token _ammount;
    _units = timeUnit();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMFLOAT:
      _ammount = jj_consume_token(NUMFLOAT);
      break;
    case NUMINT:
      _ammount = jj_consume_token(NUMINT);
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
                {if (true) return new SolTime( _units, _ammount.toString() );}
    throw new Error("Missing return statement in function");
  }

/**
 * time-unit ::= HOURS | MINUTES | SECONDS | NONE
 */
  final public SolTime.TimeUnits timeUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOURS:
      jj_consume_token(HOURS);
               {if (true) return SolTime.TimeUnits.HOURS;}
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
               {if (true) return SolTime.TimeUnits.MINUTES;}
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
               {if (true) return SolTime.TimeUnits.SECONDS;}
      break;
    case NONE:
      jj_consume_token(NONE);
               {if (true) return SolTime.TimeUnits.NONE;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * freq ::= <freq-unit> <numfloat> ")"
 */
  final public Freq freq() throws ParseException {
    Freq.FreqUnits _units;
        Token _count;
    _units = freqUnit();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMFLOAT:
      _count = jj_consume_token(NUMFLOAT);
      break;
    case NUMINT:
      _count = jj_consume_token(NUMINT);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
                {if (true) return new Freq(Double.parseDouble(_count.toString()), _units);}
    throw new Error("Missing return statement in function");
  }

/**
 *  freq-unit ::= HOURS | MINUTES | SECONDS | HZ | PM | NONE
 */
  final public Freq.FreqUnits freqUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOURS:
      jj_consume_token(HOURS);
              {if (true) return Freq.FreqUnits.HOURS;}
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
                {if (true) return Freq.FreqUnits.MINUTES;}
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
                {if (true) return Freq.FreqUnits.SECONDS;}
      break;
    case HZ:
      jj_consume_token(HZ);
           {if (true) return Freq.FreqUnits.HZ;}
      break;
    case PM:
      jj_consume_token(PM);
           {if (true) return Freq.FreqUnits.PM;}
      break;
    case NONE:
      jj_consume_token(NONE);
             {if (true) return Freq.FreqUnits.NONE;}
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Get list of senses of a trigger.
 * trigger ::= <TRIGGER> <senses> ")" 
 */
  final public List<Sense> trigger(FormalParameters formalParameters) throws ParseException {
        List<Sense> triggerSenses;
    jj_consume_token(TRIGGER);
    triggerSenses = senses(formalParameters);
    jj_consume_token(RBRACE);
          {if (true) return triggerSenses;}
    throw new Error("Missing return statement in function");
  }

/**
 * Get senses (if there are any) and return them.
 * senses ::= ( NIL | "(" ( NAME | <full-sense> )+ ")" )
 */
  final public List<Sense> senses(FormalParameters formalParameters) throws ParseException {
    List<Sense> senses;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
     {if (true) return Collections.<Sense>emptyList();}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      senses = sensesList(formalParameters);
      jj_consume_token(RBRACE);
     {if (true) return senses;}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * ( NAME | <full-sense> )+ 
 * Part of sense() rule.
 */
  final public List<Sense> sensesList(FormalParameters formalParameters) throws ParseException {
    Sense sense;
    List<Sense> sensesList = new LinkedList<Sense>();
    label_7:
    while (true) {
      sense = sensesListElement(formalParameters);
          sensesList.add(sense);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case NAME:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_7;
      }
    }
      {if (true) return sensesList;}
    throw new Error("Missing return statement in function");
  }

/**
 * NAME | <full-sense>
 * Part of sensesList() rule
 * XXX: I am using <NAME> in first case, so it is impossible to have (sense1(sense2)) vs (sense1(simple_string))
 *      because the calling vars are not compulsory, yet   
 */
  final public Sense sensesListElement(FormalParameters formalParameters) throws ParseException {
    Token senseName;
    Sense _sense;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAME:
      senseName = jj_consume_token(NAME);
      {if (true) return new Sense(senseName.toString());}
      break;
    case LBRACE:
      _sense = fullSense(formalParameters);
      {if (true) return _sense;}
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * full-sense ::= "(" NAME [<value> [<predicate>]] ")"
 */
  final public Sense fullSense(FormalParameters formalParameters) throws ParseException {
    SenseComponents _senseComp = new SenseComponents();
    PrimitiveCall senseCall;
    jj_consume_token(LBRACE);
    senseCall = senseCall(formalParameters);
    senseValue(_senseComp);
        // didn't assign
        if (_senseComp.value == null) {
            {if (true) return new Sense(senseCall);}
        } else {
            {if (true) return new Sense( senseCall, _senseComp.value, _senseComp.predicate == null
                ? cz.cuni.amis.pogamut.sposh.elements.Sense.Predicate.DEFAULT
                : _senseComp.predicate);}
        }
    throw new Error("Missing return statement in function");
  }

/**
 * SenseCall
 * sense:: <NAME> [ "(" callParametersList() ]
 */
  final public PrimitiveCall senseCall(FormalParameters formalParameters) throws ParseException {
    Arguments arguments = new Arguments();
    Token name;
    name = jj_consume_token(NAME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      arguments = callParametersList(formalParameters);
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
            {if (true) return new PrimitiveCall(name.toString(), arguments);}
    throw new Error("Missing return statement in function");
  }

/**
 * callParametersList:: callParameter() ( "," callParameter() )* ")" 
 */
  final public Arguments callParametersList(FormalParameters formalParameters) throws ParseException {
    int index=0;
    Arguments arguments = new Arguments();
    Packet<Arguments.Argument, Boolean> packet = null;
    boolean named = false;
    packet = callParameter(index, named);
            named = packet.second;
            try {
                arguments.addFormal(packet.first, formalParameters);
                ++index;
            } catch (IllegalArgumentException ex) {
                ParseException parseEx = new ParseException(ex.getMessage());
                parseEx.currentToken = token;
                {if (true) throw parseEx;}
            }
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      packet = callParameter(index, named);
            named = packet.second;
            try {
                arguments.addFormal(packet.first, formalParameters);
                ++index;
            } catch (IllegalArgumentException ex) {
                ParseException parseEx = new ParseException(ex.getMessage());
                parseEx.currentToken = token;
                {if (true) throw parseEx;}
            }
    }
    jj_consume_token(RBRACE);
        {if (true) return arguments;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parameter used when calling C/AP/sense/action
 * callParameter :: <VARIABLE> [ "=" ( <VARIABLE> | value() ) ]
 * @param named was at least one named call parameter specified in the list before this one?     
 */
  final public Packet<Arguments.Argument, Boolean> callParameter(int index, boolean named) throws ParseException {
    Token variable = null;
    Object value = null;
    Token valueVariable = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
    case TRUE:
    case FALSE:
    case NUMFLOAT:
    case NUMINT:
    case ENUM_VALUE:
    case COMMENT:
      value = value();
            if (named) {
                // sonar is complaining about \" transformed into unicode \ 
                char doubleQuote = '"';
                ParseException ex = new ParseException("Specified unnamed parameter " + doubleQuote + index + doubleQuote + " after at least one named parameter.");
                ex.currentToken = token;
                {if (true) throw ex;}
            }
            {if (true) return new Packet<Arguments.Argument, Boolean>(new Arguments.ValueArgument(index, value), false);}
      break;
    case VARIABLE:
      variable = jj_consume_token(VARIABLE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL_SIGN:
        jj_consume_token(EQUAL_SIGN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VARIABLE:
          valueVariable = jj_consume_token(VARIABLE);
                {if (true) return new Packet<Arguments.Argument, Boolean>(
                    new Arguments.VariableArgument(variable.toString(), valueVariable.toString()),
                    true);}
          break;
        case NIL:
        case TRUE:
        case FALSE:
        case NUMFLOAT:
        case NUMINT:
        case ENUM_VALUE:
        case COMMENT:
          value = value();
                {if (true) return new Packet<Arguments.Argument, Boolean>(new Arguments.ValueArgument(variable.toString(), value), true);}
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
            if (named) {
                // sonar is complaining about \" transformed into unicode \ 
                char doubleQuote = '"';
                ParseException ex = new ParseException("Specified unnamed parameter " + doubleQuote + index + doubleQuote + " after at least one named parameter.");
                ex.currentToken = token;
                {if (true) throw ex;}
            }
            {if (true) return new Packet<Arguments.Argument, Boolean>(new Arguments.VariableArgument(index, variable.toString()), false);}
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * value ::= NUMINT | NUMFLOAT | NAME | ENUM_VALUE | NIL
 * Part of full-sense parsing.
 */
  final public void senseValue(SenseComponents _senseComp) throws ParseException {
    Object _value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RBRACE:
      jj_consume_token(RBRACE);
      break;
    case NIL:
    case TRUE:
    case FALSE:
    case NUMFLOAT:
    case NUMINT:
    case ENUM_VALUE:
    case COMMENT:
      _value = value();
      sensePredicate(_senseComp);
        _senseComp.value = _value;
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * predicate ::= PREDICATE
 */
  final public void sensePredicate(SenseComponents _senseComp) throws ParseException {
    Token _predicateToken;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RBRACE:
      jj_consume_token(RBRACE);
      break;
    case PREDICATE:
      _predicateToken = jj_consume_token(PREDICATE);
      jj_consume_token(RBRACE);
        _senseComp.predicate = Sense.Predicate.getPredicate(_predicateToken.toString());
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Object value() throws ParseException {
    Token _value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMINT:
      _value = jj_consume_token(NUMINT);
        {if (true) return Integer.parseInt(_value.toString());}
      break;
    case NUMFLOAT:
      _value = jj_consume_token(NUMFLOAT);
        {if (true) return Double.parseDouble(_value.toString());}
      break;
    case TRUE:
      _value = jj_consume_token(TRUE);
        {if (true) return Boolean.TRUE;}
      break;
    case FALSE:
      _value = jj_consume_token(FALSE);
        {if (true) return Boolean.FALSE;}
      break;
    case ENUM_VALUE:
      _value = jj_consume_token(ENUM_VALUE);
        {if (true) return new EnumValue(_value.toString().substring(1));}
      break;
    case NIL:
      _value = jj_consume_token(NIL);
        {if (true) return null;}
      break;
    case COMMENT:
      _value = jj_consume_token(COMMENT);
        {if (true) return unescape(_value.toString());}
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public PoshParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[38];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x800f00,0xf00,0xc0,0xe00,0x40,0x40,0x402000,0xd82fc000,0x200040,0x200040,0x200040,0x1000000,0x2000000,0x3000,0x200040,0x40,0x40,0x40,0x80000000,0x0,0x1000000,0x1000000,0x0,0xc0000000,0x9c000,0xc0000000,0xfc000,0x200040,0x40,0x40,0x40,0x2000000,0xd8200000,0x4000000,0xd8200000,0xd8200080,0x20000080,0xd8200000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x1c,0x0,0x1c,0xc,0x0,0xc,};
   }

  /** Constructor with InputStream. */
  public PoshParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PoshParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PoshParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public PoshParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PoshParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public PoshParser(PoshParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(PoshParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 38; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[38];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 38; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 38; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}

final class SenseComponents {
    public String name;
    public Object value;
    public Sense.Predicate predicate;
}
