/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.MethodException;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

class ParamsMethod<RETURN> {
    private final Class<?>[] allowedParamClasses = new Class[]{String.class, Integer.class, Integer.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE};
    private final String methodName;
    private final Class<RETURN> returnCls;
    private final Class<?> methodClass;
    private final Method method;

    ParamsMethod(Class methodClass, String methodName, Class<RETURN> returnCls) {
        this.methodClass = methodClass;
        this.methodName = methodName;
        this.returnCls = returnCls;
        this.method = this.findMethod();
    }

    private boolean areParamsAcceptable(Method method, boolean isEnumAcceptable, Class<?> ... acceptedTypes) {
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType = classArray[n2];
            boolean paramAcceptable = false;
            Class<?>[] classArray2 = acceptedTypes;
            int n3 = acceptedTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> acceptedType = classArray2[n4];
                if (paramType.equals(acceptedType)) {
                    paramAcceptable = true;
                }
                ++n4;
            }
            if (isEnumAcceptable && paramType.isEnum() && Modifier.isPublic(paramType.getModifiers())) {
                paramAcceptable = true;
            }
            if (!paramAcceptable) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> seekedAnnotation) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(seekedAnnotation)) {
                return (T)annotation;
            }
            ++n2;
        }
        return null;
    }

    private boolean areParamsAnnotated(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] paramAnnotations = annotationArray[n2];
            if (this.getAnnotation(paramAnnotations, Param.class) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Method[] filterMethods(Method[] methods, String seekedName, Class<?> returnType) {
        LinkedList<Method> filteredMethods = new LinkedList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method testedMethod = methodArray[n2];
            String testedMethodName = testedMethod.getName();
            boolean methodIsPublic = (testedMethod.getModifiers() & 1) == 1;
            boolean methodIsAbstract = (testedMethod.getModifiers() & 0x400) == 1024;
            boolean correctReturnType = returnType.isAssignableFrom(testedMethod.getReturnType());
            boolean acceptedParams = this.areParamsAcceptable(testedMethod, true, this.allowedParamClasses);
            boolean annotatedParams = this.areParamsAnnotated(testedMethod);
            if (testedMethodName.equals(seekedName) && methodIsPublic && !methodIsAbstract && !testedMethod.isVarArgs() && correctReturnType && acceptedParams && annotatedParams) {
                filteredMethods.add(testedMethod);
            }
            ++n2;
        }
        return filteredMethods.toArray(new Method[filteredMethods.size()]);
    }

    final Method findMethod() {
        Method[] methods = this.filterMethods(this.methodClass.getMethods(), this.methodName, this.returnCls);
        if (methods.length == 0) {
            throw new NoSuchMethodError("Unable to find method " + this.methodName);
        }
        if (methods.length > 1) {
            throw new UnsupportedOperationException("Multiple (" + methods.length + ") possible " + this.methodName + " methods, overloading is not supported.");
        }
        return methods[0];
    }

    public final RETURN invoke(Object thisObject, VariableContext params) throws InvocationTargetException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Annotation[][] paramsAnnotations = this.method.getParameterAnnotations();
        assert (paramsAnnotations.length == paramTypes.length);
        int paramCount = paramTypes.length;
        LinkedList<Object> methodArguments = new LinkedList<Object>();
        int paramIndex = 0;
        while (paramIndex < paramCount) {
            Annotation[] paramAnnotations = paramsAnnotations[paramIndex];
            Param param = this.getAnnotation(paramAnnotations, Param.class);
            String variableName = param.value();
            Object argumentValue = this.getArgumentValue(thisObject, params, paramTypes[paramIndex], variableName);
            methodArguments.add(argumentValue);
            ++paramIndex;
        }
        try {
            Object ret = this.method.invoke(thisObject, methodArguments.toArray());
            return (RETURN)ret;
        }
        catch (IllegalAccessException ex) {
            throw new FubarException("findMethod filters for public methods", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new FubarException("Error with parameter maching code", ex);
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
    }

    private Object getArgumentValue(Object thisObject, VariableContext ctx, Class<?> paramType, String variableName) {
        try {
            Object argumentValue = ctx.getValue(variableName);
            if (paramType.isEnum()) {
                if (!argumentValue.getClass().equals(EnumValue.class)) {
                    throw new MethodException("Variable " + variableName + " should be an " + EnumValue.class.getSimpleName() + " string containing the FQN of an enum value.");
                }
                argumentValue = this.convertToEnumConstant(paramType, (EnumValue)argumentValue);
            }
            return argumentValue;
        }
        catch (IllegalArgumentException ex) {
            String thisObjectName = thisObject.getClass().getName();
            throw new MethodException("No variable " + variableName + " for " + thisObjectName + '.' + this.methodName + '.', ex);
        }
    }

    private Object convertToEnumConstant(Class<Enum> enumClass, EnumValue enumValue) {
        String enumValueFQNPrefix = String.valueOf(enumClass.getName()) + '.';
        String enumValueFQN = enumValue.getName();
        if (!enumValueFQN.startsWith(enumValueFQNPrefix)) {
            throw new IllegalArgumentException("Unable to convert \"" + enumValueFQN + "\" to the value of enum " + enumClass.getName() + ".");
        }
        String enumName = enumValueFQN.substring(enumValueFQNPrefix.length());
        return Enum.valueOf(enumClass, enumName);
    }
}

