/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.DCExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.List;
import java.util.logging.Logger;

public final class PoshEngine {
    private final int engineId;
    PoshPlan plan;
    ITimer timer;
    EngineLog engineLog;
    private DCExecutor dcExecutor;

    protected PoshEngine(PoshPlan plan) {
        this(plan, new SystemClockTimer());
    }

    protected PoshEngine(PoshPlan plan, ITimer timer) {
        this(0, plan, timer, Logger.getLogger(PoshEngine.class.getName()));
    }

    protected PoshEngine(PoshPlan plan, ITimer timer, Logger log) {
        this(0, plan, timer, log);
    }

    public PoshEngine(int engineId, PoshPlan plan, @Deprecated ITimer timer, Logger log) {
        this.engineId = engineId;
        this.plan = plan;
        this.timer = timer;
        this.engineLog = new EngineLog(log);
        this.reset();
    }

    public final synchronized void reset() {
        LapPath dcPath = new LapPath().concat(LapType.PLAN, this.engineId).concat(LapType.DRIVE_COLLECTION, 0);
        this.dcExecutor = new DCExecutor(this.plan, dcPath, this.timer, this.engineLog);
    }

    public synchronized EvaluationResultInfo evaluatePlan(IWorkExecutor workExecuter) {
        this.engineLog.clear();
        EvaluationResultInfo ret = this.dcExecutor.fire(workExecuter);
        this.evaluatePlanExit();
        return ret;
    }

    private void evaluatePlanExit() {
    }

    ElementStackTrace getStackForDE(String name) {
        return this.dcExecutor.getStackForDE(name);
    }

    ElementStackTrace getStackForDE(int index) {
        return this.dcExecutor.getStackForDE(index);
    }

    int getDECount() {
        return this.dcExecutor.getDECount();
    }

    String getDEName(int index) {
        return this.dcExecutor.getDEName(index);
    }

    public Logger getLog() {
        return this.engineLog.getLogger();
    }

    List<LapPath> getEvaluatedPaths() {
        return this.engineLog.getPaths();
    }

    public final PoshPlan getPlan() {
        return this.plan;
    }

    public final String getPoshPlan() {
        return this.plan.toString();
    }

    public String getName() {
        String planName = this.plan.getName();
        if (planName.isEmpty()) {
            return this.plan.getDriveCollection().getName();
        }
        return planName;
    }

    public static enum EvaluationResult {
        GOAL_SATISFIED,
        ELEMENT_FIRED,
        NO_ELEMENT_FIRED;

    }

    public static class EvaluationResultInfo {
        public EvaluationResult result;
        public FireResult.Type type;

        public EvaluationResultInfo(EvaluationResult result, FireResult.Type type) {
            this.result = result;
            this.type = type;
        }
    }
}

