/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.ADExecutor;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;

class DEExecutor
extends AbstractExecutor {
    private final PoshPlan plan;
    private final DriveElement drive;
    private final SenseListExecutor<DriveElement> trigger;
    private final Freq freq;
    private long lastFired = Integer.MAX_VALUE;
    private ElementStackTrace stackTrace = new ElementStackTrace();

    DEExecutor(PoshPlan plan, DriveElement de, LapPath drivePath, VariableContext ctx, EngineLog log) {
        super(drivePath, ctx, log);
        assert (drivePath.traversePath(plan) == de);
        this.plan = plan;
        this.drive = de;
        this.freq = de.getFreq();
        this.trigger = new SenseListExecutor<DriveElement>(de.getTrigger(), drivePath, ctx, log);
    }

    private LapPath createDriveActionPath() {
        return this.path.concat(LapType.ACTION, 0);
    }

    private StackElement createInitialStackElement(PoshPlan plan, PrimitiveCall actionCall) {
        LapPath driveActionPath = this.createDriveActionPath();
        return this.getElement(plan, actionCall, driveActionPath);
    }

    public synchronized boolean isReady(long timestamp, IWorkExecutor workExecuter) {
        long passed = timestamp - this.lastFired;
        if (Freq.compare(this.freq.tick(), passed) > 0) {
            this.engineLog.fine("Max.firing frequency for drive " + this.drive.getName() + " exceeded, has to be at least " + this.freq.tick() + "ms, but was only " + passed);
            return false;
        }
        TriggerResult triggerResult = this.trigger.fire(workExecuter, true);
        return triggerResult.wasSuccess();
    }

    public synchronized FireResult.Type fire(IWorkExecutor workExecuter, ITimer timer) {
        this.engineLog.pathReached(this.path);
        ArrayList<CExecutor> competences = new ArrayList<CExecutor>();
        int i = this.stackTrace.size() - 1;
        while (i >= 0) {
            StackElement element = (StackElement)this.stackTrace.get(i);
            if (element.getExecutor() instanceof CExecutor) {
                competences.add((CExecutor)element.getExecutor());
            } else if (element.getExecutor() instanceof ADExecutor) {
                if (!((ADExecutor)element.getExecutor()).isExit(workExecuter)) break;
                this.stackTrace.cutDownToIncluding((ElementExecutor)element.getExecutor());
                competences.clear();
            }
            --i;
        }
        i = competences.size() - 1;
        while (i >= 0) {
            CExecutor competence = (CExecutor)competences.get(i);
            if (competence.isGoalSatisfied(workExecuter)) {
                this.stackTrace.cutDownToIncluding(competence);
                break;
            }
            --i;
        }
        if (this.stackTrace.isEmpty()) {
            PrimitiveCall actionCall = this.drive.getAction().getActionCall();
            this.engineLog.finest("Stack of drive " + this.drive.getName() + " is empty, adding initial element: " + actionCall.toString());
            this.stackTrace.add(this.createInitialStackElement(this.plan, actionCall));
            return FireResult.Type.CONTINUE;
        }
        FireResult result = this.stackTrace.peek().getExecutor().fire(workExecuter);
        this.lastFired = timer.getTime();
        this.engineLog.fine("The fired element returned: " + (Object)((Object)result.getType()));
        switch (result.getType()) {
            case FULFILLED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FAILED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FOLLOW: {
                this.stackTrace.push(result.getNextElement());
                break;
            }
            case CONTINUE: {
                break;
            }
            case SURFACE: 
            case SURFACE_CONTINUE: {
                this.stackTrace.pop();
                break;
            }
            default: {
                throw new IllegalStateException("State \"" + (Object)((Object)result.getType()) + "\" not expected. Serious error.");
            }
        }
        return result.getType();
    }

    ElementStackTrace getStackTrace() {
        return this.stackTrace;
    }

    public String getName() {
        return this.drive.getName();
    }

    public void driveInterrupted() {
        while (this.stackTrace.size() > 0 && !(this.stackTrace.peek().getExecutor() instanceof ADExecutor)) {
            this.stackTrace.pop();
        }
    }
}

