/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

class ActionExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final PrimitiveCall actionCall;
    private final FireResult.Type finishedResult = FireResult.Type.SURFACE_CONTINUE;
    private final FireResult.Type runningResult = FireResult.Type.SURFACE;
    private final FireResult.Type runningOnceResult = FireResult.Type.SURFACE;
    private final FireResult.Type failedResult = FireResult.Type.FAILED;
    private final Runnable finishedResultCallback;
    private final Runnable runningResultCallback;
    private final Runnable runningOnceResultCallback;
    private final Runnable failedResultCallback;

    ActionExecutor(PrimitiveCall actionCall, Runnable finishedResultCallback, Runnable runningResultCallback, Runnable runningOnceResultCallback, Runnable failedResultCallback, LapPath actionPath, VariableContext ctx, EngineLog log) {
        super(actionPath, ctx, log);
        this.actionCall = actionCall;
        this.finishedResultCallback = finishedResultCallback;
        this.runningResultCallback = runningResultCallback;
        this.runningOnceResultCallback = runningOnceResultCallback;
        this.failedResultCallback = failedResultCallback;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        this.engineLog.pathReached(this.path);
        ActionResult result = workExecuter.executeAction(this.actionCall.getName(), this.ctx);
        switch (result) {
            case FAILED: {
                if (this.failedResultCallback != null) {
                    this.failedResultCallback.run();
                }
                return new FireResult(this.failedResult);
            }
            case FINISHED: {
                if (this.finishedResultCallback != null) {
                    this.finishedResultCallback.run();
                }
                return new FireResult(this.finishedResult);
            }
            case RUNNING: {
                if (this.runningResultCallback != null) {
                    this.runningResultCallback.run();
                }
                return new FireResult(this.runningResult);
            }
            case RUNNING_ONCE: {
                if (this.runningOnceResultCallback != null) {
                    this.runningOnceResultCallback.run();
                }
                return new FireResult(this.runningOnceResult);
            }
        }
        throw new IllegalStateException("Unexpected ActionResult: " + (Object)((Object)result));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.actionCall.getName() + "]";
    }
}

