/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.shady.ArgString;
import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import java.lang.reflect.Array;

public class Result {
    public static final String variableNameRegexp = "\\$[a-zA-Z]([_\\-a-zA-Z0-9])*";

    public static boolean isFalse(Object value) {
        if (value == null) {
            return true;
        }
        if (Result.isBoolean(value)) {
            return !Result.getBoolean(value);
        }
        if (Result.isNumber(value)) {
            return Result.getNumber(value).doubleValue() == 0.0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    public static boolean isTrue(Object value) {
        return !Result.isFalse(value);
    }

    public static boolean isNumber(Object value) {
        return value instanceof Number;
    }

    public static Number getNumber(Object value) {
        assert (Result.isNumber(value));
        return (Number)value;
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean getBoolean(Object value) {
        assert (Result.isBoolean(value));
        return (Boolean)value;
    }

    public static Object parseValue(String valueString) throws ParseException {
        assert (valueString != null);
        if ("nil".equalsIgnoreCase(valueString)) {
            return null;
        }
        if (valueString.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return Boolean.TRUE;
        }
        if (valueString.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return Boolean.FALSE;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(valueString);
            }
            catch (NumberFormatException numberFormatException2) {
                if (valueString.length() >= 2 && valueString.startsWith("\"") && valueString.endsWith("\"")) {
                    String unquotedString = valueString.substring(1, valueString.length() - 1);
                    try {
                        return ArgString.unescape(unquotedString);
                    }
                    catch (cz.cuni.amis.pogamut.shady.ParseException ex) {
                        throw new ParseException(ex.getMessage());
                    }
                }
                if (valueString.length() >= 2 && valueString.startsWith("'")) {
                    String enumString = valueString.substring(1);
                    if (!enumString.matches("[a-zA-Z_]([a-zA-Z_0-9])*(.[a-zA-Z_]([a-zA-Z_0-9])*)*")) {
                        throw new ParseException(String.valueOf(enumString) + " is not a valid enum name.");
                    }
                    return new EnumValue(enumString);
                }
                throw new ParseException("No good type from " + valueString);
            }
        }
    }

    public static double getNumerical(Object value) {
        if (Result.isBoolean(value)) {
            return Result.getBoolean(value) ? 1 : 0;
        }
        return Result.getNumber(value).doubleValue();
    }

    public static boolean isNumerical(Object value) {
        return Result.isNumber(value) || Result.isBoolean(value);
    }

    public static boolean equal(Object operand1, Object operand2) {
        if (Result.isNumerical(operand1) && Result.isNumerical(operand2)) {
            double op2;
            double op1 = Result.getNumerical(operand1);
            return op1 == (op2 = Result.getNumerical(operand2));
        }
        return operand1 == null ? operand2 == null : operand1.equals(operand2);
    }

    public static int compare(Object operand1, Object operand2) {
        if (Result.isNumerical(operand1) && Result.isNumerical(operand2)) {
            double op1 = Result.getNumerical(operand1);
            double op2 = Result.getNumerical(operand2);
            int sig = (int)Math.signum(op1 - op2);
            return sig;
        }
        if (operand1 == null) {
            if (operand2 == null) {
                return 0;
            }
            throw new IllegalArgumentException("I can't compare " + operand1 + " with " + operand2);
        }
        Comparable op1 = (Comparable)operand1;
        Comparable op2 = (Comparable)operand2;
        return op1.compareTo(op2);
    }

    public static String toLap(Object value) {
        if (value == null) {
            return "nil";
        }
        if (value instanceof Character) {
            return "\"" + value.toString() + "\"";
        }
        if (value instanceof String) {
            return "\"" + value.toString() + "\"";
        }
        if (value instanceof EnumValue) {
            return String.valueOf('\'') + ((EnumValue)value).getName();
        }
        return value.toString();
    }

    public static boolean isVariableName(String possibleVariableName) {
        return possibleVariableName.matches(variableNameRegexp);
    }
}

