/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Result;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public final class FormalParameters
extends AbstractList<Parameter> {
    private List<Parameter> parameters = new ArrayList<Parameter>();

    FormalParameters(FormalParameters parameters) {
        for (Parameter param : parameters) {
            this.add(param);
        }
    }

    public FormalParameters() {
    }

    @Override
    public Parameter get(int index) {
        return this.parameters.get(index);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Parameter set(int index, Parameter element) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(element.getName()) || param.equals(element)) continue;
            throw new IllegalArgumentException("Parameter with name \"" + element.getName() + "\" has already been specified in formal parameters.");
        }
        return this.parameters.set(index, element);
    }

    @Override
    public void add(int index, Parameter element) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(element.getName())) continue;
            throw new IllegalArgumentException("Parameter with name \"" + element.getName() + "\" has already been specified in formal parameters.");
        }
        this.parameters.add(index, element);
    }

    @Override
    public Parameter remove(int index) {
        return this.parameters.remove(index);
    }

    public boolean containsVariable(String variableName) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < this.parameters.size()) {
            String parameterString = this.parameters.get(i).toString();
            if (i == 0) {
                sb.append(parameterString);
            } else {
                sb.append(", " + parameterString);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final class Parameter {
        private final String name;
        private Object defaultValue;

        public Parameter(String name, Object defaultValue) {
            assert (name.startsWith("$"));
            assert (!name.matches("\\s"));
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return String.valueOf(this.getName()) + "=" + Result.toLap(this.getDefaultValue());
        }
    }
}

