/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Arguments
extends AbstractList<Argument> {
    public static Arguments EMPTY = new Arguments();
    private List<Argument> parameters = new ArrayList<Argument>();

    public Arguments() {
    }

    protected Arguments(Arguments parameters) {
        int i = 0;
        while (i < parameters.size()) {
            Argument parameter = parameters.get(i);
            Argument clone = parameter.clone();
            this.parameters.add(clone);
            ++i;
        }
    }

    public String[] getAllNames() {
        ArrayList<String> names = new ArrayList<String>(this.size());
        for (Argument arg : this.parameters) {
            names.add(arg.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    @Override
    public synchronized Argument get(int index) {
        return this.parameters.get(index);
    }

    @Override
    public synchronized int size() {
        return this.parameters.size();
    }

    @Override
    public void add(int index, Argument element) {
        this.parameters.add(index, element);
    }

    public synchronized boolean addFormal(Argument newArgument, FormalParameters formalParams) {
        int i = 0;
        while (i < this.parameters.size()) {
            String parameterName = this.parameters.get(i).getParameterName();
            if (parameterName != null && parameterName.equals(newArgument.getParameterName())) {
                throw new IllegalArgumentException("Named parameter \"" + newArgument.getParameterName() + "\" has already been defined.");
            }
            ++i;
        }
        return this.parameters.add(newArgument);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int argumentIndex = 0;
        while (argumentIndex < this.parameters.size()) {
            if (argumentIndex != 0) {
                sb.append(',');
            }
            Argument argument = this.parameters.get(argumentIndex);
            sb.append(argument.toString());
            ++argumentIndex;
        }
        return sb.toString();
    }

    public static abstract class Argument {
        private final String argumentName;

        protected Argument(String argumentName) {
            this.argumentName = argumentName;
        }

        public abstract Object getValue();

        public abstract String getParameterVariable();

        @Deprecated
        public String getParameterName() {
            return this.argumentName;
        }

        public String getName() {
            return this.argumentName;
        }

        public abstract String toString();

        protected abstract Argument clone();

        public static Argument createValueArgument(String argumentName, Object value) {
            return new ValueArgument(argumentName, value);
        }

        public static Argument createVariableArgument(String argumentName, String variableName) {
            return new VariableArgument(argumentName, variableName);
        }
    }

    protected static final class ValueArgument
    extends Argument {
        private final Object value;

        protected ValueArgument(int sequenceNumber, Object value) {
            super(Integer.toString(sequenceNumber));
            this.value = value;
        }

        protected ValueArgument(String parameterName, Object value) {
            super(parameterName);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getParameterVariable() {
            return null;
        }

        @Override
        public String toString() {
            if (this.getParameterName().startsWith("$")) {
                return String.valueOf(this.getParameterName()) + "=" + Result.toLap(this.value);
            }
            return Result.toLap(this.value);
        }

        @Override
        protected ValueArgument clone() {
            return new ValueArgument(this.getParameterName(), this.value);
        }
    }

    protected static final class VariableArgument
    extends Argument {
        protected final String variableName;

        protected VariableArgument(int index, String variableName) {
            super(Integer.toString(index));
            this.variableName = variableName;
        }

        protected VariableArgument(String parameterName, String variableName) {
            super(parameterName);
            this.variableName = variableName;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public String getParameterVariable() {
            return this.variableName;
        }

        @Override
        public String toString() {
            if (this.getParameterName().startsWith("$")) {
                return String.valueOf(this.getParameterName()) + "=" + this.variableName;
            }
            return this.variableName;
        }

        @Override
        protected VariableArgument clone() {
            return new VariableArgument(this.getParameterName(), this.variableName);
        }
    }
}

