/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.shady.ArgString;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.io.Reader;
import java.io.StringReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocstringTest
extends Assert {
    private PoshPlan plan;

    @Before
    public void setUp() {
        this.plan = LapElementsFactory.createPlan((String)"testDocstringDC");
    }

    @After
    public void setDown() {
        this.plan = null;
    }

    private PoshParser createParser(String parsedText) {
        return new PoshParser((Reader)new StringReader(parsedText));
    }

    private PoshParser createDocstringParser(String name, String author, String info) {
        String docString = "documentation \"" + name + "\" \"" + author + "\" \"" + info + "\")";
        return this.createParser(docString);
    }

    private void testDocstring(String name, String author, String info) throws Exception {
        PoshParser parser = this.createDocstringParser(name, author, info);
        parser.docString(this.plan);
        DocstringTest.assertEquals((Object)ArgString.unescape((String)name), (Object)this.plan.getName());
        DocstringTest.assertEquals((Object)ArgString.unescape((String)author), (Object)this.plan.getAuthor());
        DocstringTest.assertEquals((Object)ArgString.unescape((String)info), (Object)this.plan.getInfo());
    }

    @Test
    public void testEmpty() throws Exception {
        this.testDocstring("", "", "");
    }

    @Test
    public void testMultipleWords() throws Exception {
        this.testDocstring("Fun bot", "Mr. Sparky", "This bot loves to have fun.");
    }

    @Test
    public void testEscapeSequences() throws Exception {
        String commonPart = "- \\b,\\t,\\n,\\r,\\f, \\n\\t__  \\u624A \\000\\377";
        this.testDocstring("Abc " + commonPart, "Def " + commonPart, "Ghi " + commonPart);
    }

    @Test
    public void testQuotes() throws Exception {
        String commonPart = "\\' \\\\";
        this.testDocstring("Abc " + commonPart, "Def " + commonPart, "Ghi " + commonPart);
    }

    @Test
    public void testDoubleQuotes() throws Exception {
        String common = "\\\\ \\\" ' \\'";
        String unescaped = "\\ \" ' '";
        this.testDocstring(common, common, common);
        DocstringTest.assertEquals((Object)unescaped, (Object)this.plan.getName());
    }
}

