/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingParameterException;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Competence
extends PoshDummyElement<Competence, PoshPlan>
implements IParametrizedElement {
    private String name;
    private FormalParameters params = new FormalParameters();
    private final List<CompetenceElement> elements = new LinkedList<CompetenceElement>();
    private final List<CompetenceElement> elementsUm = Collections.unmodifiableList(this.elements);
    public static final String cnName = "cnName";
    public static final String cnParams = "cnParams";
    public static final DataFlavor dataFlavor = new DataFlavor(Competence.class, "competence-node");

    Competence(String name, FormalParameters params, List<CompetenceElement> elements) throws DuplicateNameException {
        this(name, params);
        for (CompetenceElement element : elements) {
            assert (element.getParent() == null);
            this.addElement(element);
        }
    }

    Competence(String name, FormalParameters params) {
        assert (name != null);
        assert (params != null);
        this.name = name;
        this.params = new FormalParameters(params);
    }

    public void addElement(CompetenceElement choice) throws DuplicateNameException {
        int beyondLastElementIndex = this.elementsUm.size();
        this.addElement(beyondLastElementIndex, choice);
    }

    public void addElement(int index, CompetenceElement choice) throws DuplicateNameException {
        assert (!choice.isChildOfParent());
        if (Competence.isUsedName(choice.getName(), this.elementsUm)) {
            throw new DuplicateNameException("Competence " + this.name + " already has element with name " + choice.getName());
        }
        this.elements.add(index, choice);
        choice.setParent(this);
        this.emitChildNode(choice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t(C ");
        sb.append(this.name);
        if (!this.params.isEmpty()) {
            sb.append(" vars(");
            sb.append(this.params.toString());
            sb.append(')');
        }
        sb.append("\n\t\t(elements");
        for (CompetenceElement element : this.elements) {
            sb.append("\n\t\t\t(");
            sb.append(element.toString());
            sb.append(")");
        }
        sb.append("\n\t\t)\n\t)");
        return sb.toString();
    }

    @Override
    public List<CompetenceElement> getChildDataNodes() {
        return this.elementsUm;
    }

    public List<CompetenceElement> getChoices() {
        return this.elementsUm;
    }

    public CompetenceElement getChoice(int choiceId) {
        return this.elementsUm.get(choiceId);
    }

    public void setName(String name) throws DuplicateNameException, CycleException, InvalidNameException {
        PoshPlan plan = this.getRootNode();
        if (!(name = name.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new InvalidNameException("Name " + name + " is not valid.");
        }
        if (!this.name.equals(name) && plan != null && !plan.isUniqueNodeName(name)) {
            throw new DuplicateNameException("New name for competence '" + this.name + "'(" + name + ") is not unique for reaction plan.");
        }
        String oldName = this.name;
        this.name = name;
        if (plan != null && plan.isCycled()) {
            this.name = oldName;
            throw new CycleException("New name (" + name + ") for competence '" + this.name + "' is causing cycle.");
        }
        this.firePropertyChange(cnName, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        assert (child instanceof CompetenceElement);
        return this.moveChildInList(this.elements, (CompetenceElement)child, newIndex);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public LapType getType() {
        return LapType.COMPETENCE;
    }

    public void removeElement(CompetenceElement element) {
        assert (this.elements.contains(element));
        if (this.elements.size() == 1) {
            String unusedName = Competence.getUnusedName("choice-", this.elementsUm);
            try {
                this.addElement(LapElementsFactory.createCompetenceElement(unusedName));
            }
            catch (DuplicateNameException ex) {
                String msg = "Unused name " + unusedName + " is not unused.";
                Logger.getLogger(Competence.class.getName()).log(Level.SEVERE, msg, ex);
                throw new FubarException(msg, ex);
            }
        }
        int removedElementPosition = this.elementsUm.indexOf(element);
        this.elements.remove(element);
        element.setParent(null);
        this.emitChildDeleted(element, removedElementPosition);
    }

    @Override
    public FormalParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(FormalParameters newParams) throws MissingParameterException {
        for (CompetenceElement cel : this.elementsUm) {
            Arguments args = cel.getAction().getArguments();
            for (Arguments.Argument arg : args) {
                String parameterName = arg.getParameterVariable();
                if (parameterName == null || newParams.containsVariable(parameterName)) continue;
                throw new MissingParameterException(parameterName);
            }
        }
        FormalParameters oldParams = this.params;
        this.params = newParams;
        this.firePropertyChange(cnParams, oldParams, newParams);
    }

    public final void rename(String newCompetenceName) throws InvalidNameException, CycleException, DuplicateNameException {
        PoshPlan plan = this.getRootNode();
        if (plan == null) {
            throw new IllegalStateException("Competence " + this.getName() + " is not part of the plan.");
        }
        List<TriggeredAction> allReferences = plan.getAllReferences();
        LinkedList<TriggeredAction> referencingActions = new LinkedList<TriggeredAction>();
        for (TriggeredAction planAction : allReferences) {
            boolean actionReferencesCompetence = planAction.getName().equals(this.getName());
            if (!actionReferencesCompetence) continue;
            referencingActions.add(planAction);
        }
        for (TriggeredAction referencingAction : referencingActions) {
            referencingAction.setActionName(newCompetenceName);
        }
        this.setName(newCompetenceName);
    }

    public int getChoiceId(CompetenceElement choice) {
        return this.getElementId(this.elementsUm, choice);
    }
}

