/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.DEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;

final class DCExecutor
extends AbstractExecutor {
    private SenseListExecutor<DriveCollection> goalExecutor;
    private List<DEExecutor> deExecutors = new ArrayList<DEExecutor>();
    private DEExecutor lastTriggeredDrive = null;
    private ITimer timer;

    protected DCExecutor(PoshPlan plan, LapPath dcPath, ITimer timer, EngineLog engineLog) {
        super(dcPath, new VariableContext(), engineLog);
        DriveCollection dc = plan.getDriveCollection();
        assert (this.path.traversePath(plan) == dc);
        this.timer = timer;
        this.goalExecutor = new SenseListExecutor<DriveCollection>(dc.getGoal(), this.path, this.ctx, engineLog);
        int driveId = 0;
        for (DriveElement drive : dc.getDrives()) {
            LapPath drivePath = this.path.concat(LapType.DRIVE_ELEMENT, driveId++);
            this.deExecutors.add(new DEExecutor(plan, drive, drivePath, this.ctx, engineLog));
        }
    }

    public synchronized PoshEngine.EvaluationResultInfo fire(IWorkExecutor workExecuter) {
        FireResult.Type resultType = null;
        TriggerResult triggerResult = this.goalExecutor.fire(workExecuter, false);
        if (triggerResult.wasSuccess()) {
            return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.GOAL_SATISFIED, FireResult.Type.FULFILLED);
        }
        for (DEExecutor deExecutor : this.deExecutors) {
            if (!deExecutor.isReady(this.timer.getTime(), workExecuter)) continue;
            if (this.lastTriggeredDrive != null && this.lastTriggeredDrive != deExecutor) {
                this.lastTriggeredDrive.driveInterrupted();
            }
            this.lastTriggeredDrive = deExecutor;
            resultType = deExecutor.fire(workExecuter, this.timer);
            return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.ELEMENT_FIRED, resultType);
        }
        return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, FireResult.Type.FAILED);
    }

    int getDECount() {
        return this.deExecutors.size();
    }

    String getDEName(int index) {
        return this.deExecutors.get(index).getName();
    }

    ElementStackTrace getStackForDE(int index) {
        return this.deExecutors.get(index).getStackTrace();
    }

    ElementStackTrace getStackForDE(String name) {
        DEExecutor result = null;
        for (DEExecutor de : this.deExecutors) {
            boolean bl = de.getName() == null ? name == null : de.getName().equals(name);
            boolean equal = bl;
            if (!equal) continue;
            if (result == null) {
                result = de;
                continue;
            }
            throw new IllegalStateException("Two drive elements with name \"" + name + "\".");
        }
        if (result != null) {
            return result.getStackTrace();
        }
        return null;
    }
}

