package cz.cuni.amis.pogamut.sposh.elements;

/**
 * All elements that can exists in the plan and their type names that will be
 * used in the path.
 */
public enum LapType {

    ACTION("A", TriggeredAction.class),
    ACTION_PATTERN("AP", ActionPattern.class),
    ADOPT("AD", Adopt.class),
    COMPETENCE("C", Competence.class),
    COMPETENCE_ELEMENT("CE", CompetenceElement.class),
    DRIVE_COLLECTION("DC", DriveCollection.class),
    DRIVE_ELEMENT("DE", DriveElement.class),
    PLAN("P", PoshPlan.class),
    SENSE("S", Sense.class);

    private final String pathName;
    private final Class<?> typeClass;

    private LapType(String name, Class<?> typeClass) {
        this.pathName = name;
        this.typeClass = typeClass;
    }

    public String getName() {
        return pathName;
    }

    public Class<?> getTypeClass() {
        return typeClass;
    }
}
