package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

public class Adopt extends PoshDummyElement<Adopt, PoshPlan> implements IParametrizedElement {
	
	/**
     * Data flavor of adopt class, used for drag-and-drop
     */
    public static final DataFlavor dataFlavor = new DataFlavor(Adopt.class, "adopt-node");
    
    /**
     * Property string of competence name
     */
    public static final String adName = "adName";
	
	private String name;
	
	private FormalParameters parameters;
    
    private Trigger<Adopt> exitCondition;
    
    private TriggeredAction adoptedElement;

    public Adopt(String name, FormalParameters parameters, List<Sense> exitCondition, PrimitiveCall adoptedElement) {
    	this.name = name;
    	this.parameters = parameters;
    	
    	this.exitCondition =  new Trigger<Adopt>(this, exitCondition);
    	
    	this.adoptedElement = LapElementsFactory.createAction(adoptedElement);
        this.adoptedElement.setParent(this);
    }
    
	public FormalParameters getParameters() {
		return parameters;
	}

	public void setParameters(FormalParameters parameters) {
		this.parameters = parameters;
	}

	@Override
	public String getName() {
		return name;
	}
	
	public void setName(String name) throws InvalidNameException, DuplicateNameException, CycleException {
		PoshPlan plan = getRootNode();

        name = name.trim();

        if (!name.matches(IDENT_PATTERN)) {
            throw new InvalidNameException("Name " + name + " is not valid.");
        }

        // Check for duplicity
        if (!this.name.equals(name)) {
            if (plan != null && !plan.isUniqueNodeName(name)) {
                throw new DuplicateNameException("New name for adopt '" + this.name + "'(" + name + ") is not unique for reaction plan.");
            }
        }

        String oldName = this.name;
        this.name = name;

        if (plan != null && plan.isCycled()) {
            this.name = oldName;
            throw new CycleException("New name (" + name + ") for adopt '" + this.name + "' is causing cycle.");
        }
        firePropertyChange(adName, oldName, name);
	}

	public void addCondition(Sense sense) {
		exitCondition.add(sense);
	}
	
	public Trigger<Adopt> getExitCondition() {
		return exitCondition;
	}

	public TriggeredAction getAdoptedElement() {
		return adoptedElement;
	}

	public void setAdoptedElement(TriggeredAction adoptedElement) {
		this.adoptedElement = adoptedElement;
	}
	
	@Override
	public DataFlavor getDataFlavor() {
		return dataFlavor;
	}
    
    @Override
    public LapType getType() {
        return LapType.ADOPT;
    }
	
	@Override
	public List<? extends PoshElement> getChildDataNodes() {
        List<PoshElement> children = new ArrayList<PoshElement>();
        children.addAll(exitCondition);
        children.add(this.adoptedElement);

        return children;
	}

	@Override
	public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException("Moving Adopt doesn't make sense.");
	}

}
