/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.shady;

import cz.cuni.amis.pogamut.shady.Arg;
import cz.cuni.amis.pogamut.shady.ArgChar;
import cz.cuni.amis.pogamut.shady.ParseException;

public class ArgString
extends Arg<String> {
    public ArgString(String string) {
        super(string);
    }

    public static String unescape(String escapedString) throws ParseException {
        if (escapedString.length() == 0) {
            return escapedString;
        }
        return ArgString.parseStringCharacters(new StringBuilder(escapedString));
    }

    protected static String parseStringLiteral(String escaped) throws ParseException {
        StringBuilder sb = new StringBuilder(escaped);
        if (sb.charAt(0) != '\"') {
            throw new ParseException("Expecting \" at the start of " + escaped.toString());
        }
        sb.deleteCharAt(0);
        String parsed = "";
        if (sb.length() != 1) {
            parsed = ArgString.parseStringCharacters(sb);
        }
        if (sb.length() != 1) {
            throw new ParseException("Expecting exactly one character (double quote), but " + sb.length() + " characters remain:" + sb.toString());
        }
        if (sb.charAt(0) != '\"') {
            throw new ParseException("Expecting ending double quote, but got: " + sb.charAt(0));
        }
        return parsed.toString();
    }

    private static String parseStringCharacters(StringBuilder sb) throws ParseException {
        Character ch;
        StringBuilder stringCharacters = new StringBuilder();
        while ((ch = ArgString.parseStringCharacter(sb)) != null) {
            stringCharacters.append(ch);
        }
        return stringCharacters.toString();
    }

    protected static Character parseStringCharacter(StringBuilder sb) throws ParseException {
        if (sb.length() == 0) {
            return null;
        }
        char ch = sb.charAt(0);
        if (ch == '\"' || ch == '\r' || ch == '\n') {
            return null;
        }
        sb.deleteCharAt(0);
        if (ch == '\\') {
            Character res = ArgChar.parseEscapeSequence(sb);
            if (res == null) {
                throw new ParseException("Unable to unescape sequence:" + sb.toString());
            }
            return res;
        }
        return Character.valueOf(ch);
    }
}

