/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ExceptionMethod;
import cz.cuni.amis.pogamut.sposh.executor.MissingAnnotationMethod;
import cz.cuni.amis.pogamut.sposh.executor.MissingMethod;
import cz.cuni.amis.pogamut.sposh.executor.MultipleMethods;
import cz.cuni.amis.pogamut.sposh.executor.ObjectTypeMethods;
import cz.cuni.amis.pogamut.sposh.executor.ParamsMethod;
import cz.cuni.amis.pogamut.sposh.executor.SimpleTypeMethods;
import cz.cuni.amis.pogamut.sposh.executor.SingleParamMethod;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParamsMethodTest
extends Assert {
    private final String target = "Liberty Prime";
    private final Double pi = Math.PI;
    private final Integer distance = 12;
    private VariableContext ctx;

    @Before
    public void setUp() {
        this.ctx = new VariableContext();
        this.ctx.put("$target", (Object)"Liberty Prime");
        this.ctx.put("$distance", (Object)this.distance);
        this.ctx.put("$pi", (Object)this.pi);
    }

    @Test
    public void singleParameter() throws InvocationTargetException {
        SingleParamMethod thisClass = new SingleParamMethod();
        ParamsMethod parameterMethod = new ParamsMethod(SingleParamMethod.class, "init", Void.TYPE);
        parameterMethod.invoke((Object)thisClass, this.ctx);
        ParamsMethodTest.assertEquals((Object)"Liberty Prime", (Object)thisClass.value);
    }

    @Test(expected=NoSuchMethodError.class)
    public void missingMethod() {
        MissingMethod missingMethodObject = new MissingMethod();
        ParamsMethod method = new ParamsMethod(missingMethodObject.getClass(), "init", Void.TYPE);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void overloadingMethods() {
        MultipleMethods multipleMethodsObject = new MultipleMethods();
        ParamsMethod method = new ParamsMethod(multipleMethodsObject.getClass(), "init", Void.TYPE);
    }

    @Test(expected=NoSuchMethodError.class)
    public void missingParamAnnotation() {
        MissingAnnotationMethod missingAnnotationObject = new MissingAnnotationMethod();
        ParamsMethod method = new ParamsMethod(missingAnnotationObject.getClass(), "init", Void.TYPE);
    }

    @Test
    public void doubleParameter() throws InvocationTargetException {
        SimpleTypeMethods simpleTypeMethods = new SimpleTypeMethods();
        ParamsMethod method = new ParamsMethod(simpleTypeMethods.getClass(), "doubleParam", Double.TYPE);
        Double retVal = (Double)method.invoke((Object)simpleTypeMethods, this.ctx);
        ParamsMethodTest.assertEquals((Object)this.pi, (Object)retVal);
    }

    @Test
    public void intParameter() throws InvocationTargetException {
        SimpleTypeMethods simpleTypeMethods = new SimpleTypeMethods();
        ParamsMethod method = new ParamsMethod(simpleTypeMethods.getClass(), "intParam", Integer.TYPE);
        Integer retVal = (Integer)method.invoke((Object)simpleTypeMethods, this.ctx);
        ParamsMethodTest.assertEquals((Object)this.distance, (Object)retVal);
    }

    @Test
    public void DoubleParameter() throws InvocationTargetException {
        ObjectTypeMethods objectTypeMethods = new ObjectTypeMethods();
        ParamsMethod method = new ParamsMethod(objectTypeMethods.getClass(), "doubleParam", Double.class);
        Double retVal = (Double)method.invoke((Object)objectTypeMethods, this.ctx);
        ParamsMethodTest.assertEquals((Object)this.pi, (Object)retVal);
    }

    @Test
    public void IntParameter() throws InvocationTargetException {
        ObjectTypeMethods objectTypeMethods = new ObjectTypeMethods();
        ParamsMethod method = new ParamsMethod(objectTypeMethods.getClass(), "intParam", Integer.class);
        Integer retVal = (Integer)method.invoke((Object)objectTypeMethods, this.ctx);
        ParamsMethodTest.assertEquals((Object)this.distance, (Object)retVal);
    }

    @Test
    public void StringParameter() throws InvocationTargetException {
        ObjectTypeMethods objectTypeMethods = new ObjectTypeMethods();
        ParamsMethod method = new ParamsMethod(objectTypeMethods.getClass(), "stringParam", String.class);
        String retVal = (String)method.invoke((Object)objectTypeMethods, this.ctx);
        ParamsMethodTest.assertEquals((Object)"Liberty Prime", (Object)retVal);
    }

    @Test(expected=InvocationTargetException.class)
    public void exceptionInMethod() throws InvocationTargetException {
        ExceptionMethod exceptionMethodObject = new ExceptionMethod();
        ParamsMethod method = new ParamsMethod(exceptionMethodObject.getClass(), "exception", Void.TYPE);
        method.invoke((Object)exceptionMethodObject, this.ctx);
    }
}

