/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import org.junit.Assert;
import org.junit.Test;

public class ValueTest {
    private void testValueFail(String value, Class clazz) {
        Object parsedValue;
        try {
            parsedValue = Result.parseValue((String)value);
        }
        catch (ParseException ex) {
            return;
        }
        if (clazz.isInstance(parsedValue)) {
            Assert.fail((String)("Value created from string \"" + value + "\" is not " + clazz + " but " + parsedValue.getClass()));
        }
    }

    private void testValueSucceed(String value, Class clazz) throws ParseException {
        Object parsedValue = Result.parseValue((String)value);
        if (!clazz.isInstance(parsedValue)) {
            Assert.fail((String)("Value created from string \"" + value + "\" is not " + clazz + " but " + parsedValue.getClass()));
        }
    }

    @Test
    public void parseNil() throws ParseException {
        Object expectedValue = null;
        Object parsedValue = Result.parseValue((String)"nil");
        Assert.assertEquals(expectedValue, (Object)parsedValue);
    }

    @Test
    public void parseTrue() throws ParseException {
        this.testValueSucceed("true", Boolean.class);
        this.testValueSucceed("True", Boolean.class);
        this.testValueSucceed("TRue", Boolean.class);
        this.testValueFail("1", Boolean.class);
    }

    @Test
    public void parseFals() throws ParseException {
        this.testValueSucceed("False", Boolean.class);
        this.testValueSucceed("false", Boolean.class);
        this.testValueSucceed("falSe", Boolean.class);
    }

    @Test
    public void testInt() throws ParseException {
        this.testValueSucceed("-12", Integer.class);
        this.testValueSucceed("12", Integer.class);
        this.testValueFail("12.0", Integer.class);
        this.testValueFail("12.0d", Integer.class);
    }

    @Test
    public void testDouble() throws ParseException {
        this.testValueSucceed("99.0", Double.class);
        this.testValueSucceed("-345.75", Double.class);
        this.testValueSucceed(".54", Double.class);
        this.testValueSucceed("-.88", Double.class);
        this.testValueFail(".8.4", Double.class);
    }

    @Test
    public void stringInQuotes() throws ParseException {
        String expectedText = "Hello World!";
        String planText = '\"' + expectedText + '\"';
        Object parsedText = Result.parseValue((String)planText);
        Assert.assertEquals((Object)expectedText, (Object)parsedText);
    }
}

