/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LapPathTest
extends Assert {
    private PoshPlan plan;
    private DriveCollection dc;

    private LapPath getDrivePath(int driveId) {
        return new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 0).append(LapType.DRIVE_ELEMENT, driveId);
    }

    private String loadPlan(String relativeResourcePath) throws IOException {
        String line;
        String resourcePath = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + '/' + relativeResourcePath;
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            LapPathTest.fail((String)("Unable to open resource \"" + resourcePath + "\""));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        reader.close();
        return sb.toString();
    }

    private PoshPlan parsePlan(String relativeResourcePath) throws IOException, ParseException {
        String plan = this.loadPlan(relativeResourcePath);
        PoshParser parser = new PoshParser((Reader)new StringReader(plan));
        return parser.parsePlan();
    }

    @Before
    public void setUp() throws IOException, ParseException {
        this.plan = this.parsePlan("testplans/LapPath-00-variouspaths.lap");
        this.dc = this.plan.getDriveCollection();
    }

    @Test(expected=IllegalStateException.class)
    public void emptyPath() {
        LapPath path = new LapPath();
        path.traversePath(this.plan);
    }

    @Test
    public void planPath() {
        LapPath path = new LapPath().append(LapType.PLAN, 0);
        PoshElement node = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)this.plan, (Object)node);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void illegalPlanPath() {
        LapPath path = new LapPath().append(LapType.PLAN, 1);
        path.traversePath(this.plan);
    }

    @Test(expected=IllegalStateException.class)
    public void firstLinkMustBePlan() {
        LapPath path = new LapPath().append(LapType.DRIVE_COLLECTION, 0);
        path.traversePath(this.plan);
    }

    @Test
    public void dcPath() {
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 0);
        PoshElement dc = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)this.plan.getDriveCollection(), (Object)dc);
    }

    @Test(expected=IllegalStateException.class)
    public void secondLinkMustBeDC() {
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.ACTION_PATTERN, 0);
        path.traversePath(this.plan);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void idOfDriveCollectionIsAlwaysZero() {
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 2);
        path.traversePath(this.plan);
    }

    @Test
    public void driveCollectionGoalPath() {
        int goalSenseId = 1;
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 0).append(LapType.SENSE, goalSenseId);
        PoshElement goalSense = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)this.dc.getGoal().get(goalSenseId), (Object)goalSense);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void driveCollectionIllegalGoalPath() {
        int goalSenseId = 666;
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 0).append(LapType.SENSE, goalSenseId);
        path.traversePath(this.plan);
    }

    @Test(expected=IllegalStateException.class)
    public void illegalThirdLink() {
        LapPath path = new LapPath().append(LapType.PLAN, 0).append(LapType.DRIVE_COLLECTION, 0).append(LapType.ACTION, 0);
        path.traversePath(this.plan);
    }

    @Test
    public void drivePath() {
        int driveId = 2;
        LapPath path = this.getDrivePath(driveId);
        PoshElement drive = path.traversePath(this.plan);
        LapPathTest.assertEquals(this.dc.getDrives().get(driveId), (Object)drive);
    }

    @Test
    public void driveAction() {
        LapPath path = this.getDrivePath(1).append(LapType.ACTION, 0);
        PoshElement action = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)((DriveElement)this.dc.getDrives().get(1)).getAction(), (Object)action);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void driveActionHasIndexZero() {
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 1);
        path.traversePath(this.plan);
    }

    @Test
    public void driveTrigger() {
        int driveId = 1;
        int driveTriggerSenseId = 1;
        LapPath path = this.getDrivePath(driveId).append(LapType.SENSE, driveTriggerSenseId);
        PoshElement sense = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)((DriveElement)this.dc.getDrives().get(driveId)).getTrigger().get(driveTriggerSenseId), (Object)sense);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void driveTriggerIndexOutOfBounds() {
        int driveId = 1;
        int driveTriggerSenseId = 3;
        LapPath path = this.getDrivePath(driveId).append(LapType.SENSE, driveTriggerSenseId);
        path.traversePath(this.plan);
    }

    @Test(expected=IllegalStateException.class)
    public void illegalReference() {
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.DRIVE_COLLECTION, 0);
        path.traversePath(this.plan);
    }

    @Test
    public void actionPatternPath() {
        int apId = 0;
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.ACTION_PATTERN, apId);
        PoshElement ap = path.traversePath(this.plan);
        LapPathTest.assertEquals(this.plan.getActionPatterns().get(apId), (Object)ap);
    }

    @Test(expected=IllegalStateException.class)
    public void wrongActionPatternForAction() {
        int apId = 1;
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.ACTION_PATTERN, apId);
        path.traversePath(this.plan);
    }

    @Test
    public void competencePath() {
        int competenceId = 1;
        LapPath path = this.getDrivePath(3).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId);
        PoshElement competence = path.traversePath(this.plan);
        LapPathTest.assertEquals(this.plan.getCompetences().get(competenceId), (Object)competence);
    }

    @Test(expected=IllegalStateException.class)
    public void wrongCompetenceForAction() {
        int competenceId = 2;
        LapPath path = this.getDrivePath(0).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId);
        path.traversePath(this.plan);
    }

    @Test
    public void actionPatternActionPath() {
        int apId = 0;
        int actionId = 2;
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.ACTION_PATTERN, apId).append(LapType.ACTION, actionId);
        PoshElement action = path.traversePath(this.plan);
        LapPathTest.assertEquals(((ActionPattern)this.plan.getActionPatterns().get(apId)).getActions().get(actionId), (Object)action);
    }

    @Test(expected=IllegalStateException.class)
    public void actionPatternIncorrectChildtype() {
        int apId = 0;
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.ACTION_PATTERN, apId).append(LapType.SENSE, 0);
        path.traversePath(this.plan);
    }

    @Test
    public void actionPatternInActionPatternPath() {
        int firstApId = 0;
        int secondApId = 1;
        int actionId = 1;
        LapPath path = this.getDrivePath(2).append(LapType.ACTION, 0).append(LapType.ACTION_PATTERN, firstApId).append(LapType.ACTION, actionId).append(LapType.ACTION_PATTERN, secondApId);
        PoshElement secondAp = path.traversePath(this.plan);
        LapPathTest.assertEquals(this.plan.getActionPatterns().get(secondApId), (Object)secondAp);
    }

    @Test
    public void choicePath() {
        int competenceId = 1;
        int choiceId = 2;
        LapPath path = this.getDrivePath(3).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId).append(LapType.COMPETENCE_ELEMENT, choiceId);
        PoshElement choice = path.traversePath(this.plan);
        LapPathTest.assertEquals(((Competence)this.plan.getCompetences().get(competenceId)).getChildDataNodes().get(choiceId), (Object)choice);
    }

    @Test(expected=IllegalStateException.class)
    public void competenceWrongLink() {
        int competenceId = 1;
        LapPath path = this.getDrivePath(3).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId).append(LapType.DRIVE_ELEMENT, 0);
        path.traversePath(this.plan);
    }

    @Test
    public void choiceTriggerPath() {
        int competenceId = 1;
        int choiceId = 1;
        int choiceTriggerSenseId = 0;
        LapPath path = this.getDrivePath(3).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId).append(LapType.COMPETENCE_ELEMENT, choiceId).append(LapType.SENSE, choiceTriggerSenseId);
        PoshElement choiceTrigggerSense = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)((CompetenceElement)((Competence)this.plan.getCompetences().get(competenceId)).getChildDataNodes().get(choiceId)).getTrigger().get(choiceTriggerSenseId), (Object)choiceTrigggerSense);
    }

    @Test
    public void choiceActionPath() {
        int competenceId = 1;
        int choiceId = 1;
        LapPath path = this.getDrivePath(3).append(LapType.ACTION, 0).append(LapType.COMPETENCE, competenceId).append(LapType.COMPETENCE_ELEMENT, choiceId).append(LapType.ACTION, 0);
        PoshElement choiceAction = path.traversePath(this.plan);
        LapPathTest.assertEquals((Object)((CompetenceElement)((Competence)this.plan.getCompetences().get(competenceId)).getChildDataNodes().get(choiceId)).getAction(), (Object)choiceAction);
    }
}

