/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class LapPathParseTest
extends Assert {
    @Test(expected=ParseException.class)
    public void emptyPath() throws ParseException {
        LapPath.parse((String)"");
    }

    @Test
    public void planPath() throws ParseException {
        LapPath parsedPath = LapPath.parse((String)"/P:0");
        LapPath expectedPath = new LapPath().append(LapType.PLAN, 0);
        LapPathParseTest.assertEquals((Object)expectedPath, (Object)parsedPath);
    }

    @Test
    public void equalPaths() throws ParseException {
        String path = "/P:0/DC:0/DE:5/A:0/AP:4";
        LapPath expectedPath = LapPath.parse((String)path);
        LapPath parsedPath = LapPath.parse((String)path);
        LapPathParseTest.assertEquals((Object)expectedPath, (Object)parsedPath);
    }

    @Test
    public void unequalPaths() throws ParseException {
        String path = "/P:0/DC:0/DE:5/A:0/AP:4";
        LapPath expectedPath = LapPath.parse((String)path);
        String differentPath = "/P:0/DC:0/DC:5/A:0/AP:4";
        LapPath parsedPath = LapPath.parse((String)differentPath);
        LapPathParseTest.assertNotSame((Object)expectedPath, (Object)parsedPath);
    }

    @Test(expected=ParseException.class)
    public void incorrentId() throws ParseException {
        LapPath.parse((String)"/P:-1");
    }

    @Test(expected=ParseException.class)
    public void incorrentType() throws ParseException {
        LapPath.parse((String)"/P:0/DC:0/DE:4/ACTION:0/AP:2");
    }

    @Test(expected=ParseException.class)
    public void extraSpace() throws ParseException {
        LapPath.parse((String)"/P: 0");
    }

    @Test(expected=ParseException.class)
    public void missingType() throws ParseException {
        LapPath.parse((String)"/P:0/:5");
    }

    @Test(expected=ParseException.class)
    public void missingId() throws ParseException {
        LapPath.parse((String)"/P:0/DC:");
    }

    @Test(expected=ParseException.class)
    public void missingTypeSeparator() throws ParseException {
        LapPath.parse((String)"/P0");
    }

    @Test
    public void parseEvenIncorrectOrder() throws ParseException {
        LapPath.parse((String)"/DC:2/P:8/AP:5");
    }
}

