package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.*;
import cz.cuni.amis.pogamut.sposh.engine.FireResult.Type;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/**
 * Executor for competence.
 * @author Honza
 */
final class CExecutor extends AbstractExecutor implements ElementExecutor {

    private SenseListExecutor goalExecutor;
    private List<CEExecutor> ceExecutors = new ArrayList<CEExecutor>();
    private TriggerResult triggerResult;
    /**
     * Create new competence executor
     * @param plan plan used to resolve names of primitives into S/A/AP/C
     * @param c competence to execute
     * @param ctx variable context of competence
     * @param log logger to record actions of this executor, can be null
     */
    public CExecutor(PoshPlan plan, Competence c, VariableContext ctx, Logger log) {
        super(ctx, log);
        // XXX: What to do with goalExecutor?
        goalExecutor = new SenseListExecutor<Competence>(ctx, log);

        for (CompetenceElement ce : c.getChildDataNodes()) {
            ceExecutors.add(new CEExecutor(plan, ce, ctx, log));
        }
    }
    
    /** 
     * Checks whether competence goal has been met.
     * @param workExecutor
     * @return
     */
    public boolean isGoalSatisfied(IWorkExecutor workExecutor) {
    	if (goalExecutor == null) return false;
    	return goalExecutor.fire(workExecutor, false).wasSuccess();
	}

    /**
     * Check if goal is not satisfied, if it is, there is no need to continue to
     * execute this competence (return {@link Type#FULFILLED}).
     * <p>
     * For all CE in priority order:
     *   Check if CE retry limit hasn't been exceeded and if the CE trigger is valid.
     *   If element is primitive, fire it.
     *   If it is AP or C, return it as next element on the stack
     *
     * If none of CE can be fired, the C failed and there is no need to continue {@link Type#FAILED};
     *
     * @param workExecuter
     * @return
     */
    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        // is goal satisfied?
        // TODO: What should I do with goal of competence? It would be best to remove it completely.
        TriggerResult goalResult = goalExecutor.fire(workExecuter, false);
        if (goalResult.wasSuccess()) {
            return new FireResult(FireResult.Type.FULFILLED);
        }

        for (CEExecutor ceExecutor : ceExecutors) {
            triggerResult = ceExecutor.isReady(workExecuter);
            if (triggerResult.wasSuccess()) {
                StackElement stackElement = new StackElement(CompetenceElement.class, ceExecutor.getName(), ceExecutor);
                return new FireResult(FireResult.Type.FOLLOW, stackElement);
            }
        }
        // If no element was fired, we have failed
        return new FireResult(FireResult.Type.FAILED);
    }

    @Override
    public TriggerResult getTriggerResult() {
        return triggerResult;
    }

}
