package cz.cuni.amis.pogamut.sposh.engine;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.FireResult.Type;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

public class ADExecutor extends AbstractExecutor implements ElementExecutor {

	private Adopt adapt;
	private PoshPlan plan;	 
	private SenseListExecutor<Adopt> exitConditionExecutor;
	 
	protected ADExecutor(PoshPlan plan, Adopt ad, VariableContext ctx, Logger log) {
		super(ctx, log);
		this.plan = plan;
		this.adapt = ad;
		this.exitConditionExecutor = new SenseListExecutor<Adopt>(ad.getExitCondition(), ctx, log);
	}
	
	public boolean isExit(IWorkExecutor workExecutor) {
		return exitConditionExecutor.fire(workExecutor, true).wasSuccess();
	}
	  
	public Trigger<Adopt> getExitCondition() {
		return adapt.getExitCondition();
	}
	
	public TriggeredAction getAdoptedElement() {
		return adapt.getAdoptedElement();
	}
	 
	@Override
	public FireResult fire(IWorkExecutor workExecuter) {
		if (isExit(workExecuter)) {
			// we've met exit-condition
			return new FireResult(Type.SURFACE);
		}
		return new FireResult(Type.FOLLOW, newTriggeredAction());		
	}

	private StackElement newTriggeredAction() {
		return getElement(plan, getAdoptedElement().getActionCall(), Type.SURFACE, Type.SURFACE, Type.SURFACE, Type.FAILED);
	}

	@Override
	public TriggerResult getTriggerResult() {
		return new TriggerResult(true);
	}

}
