package cz.cuni.amis.pogamut.sposh.elements;

/**
 * This class specifies call to some primitive (either sense or action). To do that, it requires
 * <ul>
 * <li>name of primitive</li>
 * <li>list of parameters</li>
 * <ul>
 */
public class PrimitiveCall {

	private final String name;
	private final Arguments parameters;

	/**
	 * This is a sensecall without parameters
	 * 
	 * @param name
	 */
	protected PrimitiveCall(String name) {
		this.name = name;
		this.parameters = new Arguments();
	}

    /**
     * Copy constructor.
     * @param original Original primitive call from which we take the data.
     */
	protected PrimitiveCall(PrimitiveCall original) {
		this.name = original.getName();
		this.parameters = new Arguments(original.getParameters());
	}
    
	protected PrimitiveCall(String name, Arguments parameters) {
		this.name = name;
		this.parameters = new Arguments(parameters);
	}

	public String getName() {
		return name;
	}

	/**
	 * @return unmodifiable list of parameters in correct order.
	 */
	public Arguments getParameters() {
		return parameters;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(name);
		if (!parameters.isEmpty()) {
			sb.append('(');
			sb.append(parameters.toString());
			sb.append(')');
		}
		return sb.toString();
	}
}