package cz.cuni.amis.pogamut.sposh.elements;

/**
 * All elements that can exists in the plan and their type names that will be
 * used in the path.
 */
public enum LapType {

    ACTION("A"),
    ACTION_PATTERN("AP"),
    ADOPT("AD"),
    COMPETENCE("C"),
    COMPETENCE_ELEMENT("CE"),
    DRIVE_COLLECTION("DC"),
    DRIVE_ELEMENT("DE"),
    PLAN("P"),
    SENSE("S");

    private final String pathName;

    private LapType(String name) {
        this.pathName = name;
    }

    public String getName() {
        return pathName;
    }
}
