/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class CExecutor
extends AbstractExecutor
implements ElementExecutor {
    private SenseListExecutor goalExecutor;
    private List<CEExecutor> ceExecutors = new ArrayList<CEExecutor>();
    private TriggerResult triggerResult;

    public CExecutor(PoshPlan plan, Competence c, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.goalExecutor = new SenseListExecutor(ctx, log);
        for (CompetenceElement ce : c.getChildDataNodes()) {
            this.ceExecutors.add(new CEExecutor(plan, ce, ctx, log));
        }
    }

    public boolean isGoalSatisfied(IWorkExecutor workExecutor) {
        if (this.goalExecutor == null) {
            return false;
        }
        return this.goalExecutor.fire(workExecutor, false).wasSuccess();
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        TriggerResult goalResult = this.goalExecutor.fire(workExecuter, false);
        if (goalResult.wasSuccess()) {
            return new FireResult(FireResult.Type.FULFILLED);
        }
        for (CEExecutor ceExecutor : this.ceExecutors) {
            this.triggerResult = ceExecutor.isReady(workExecuter);
            if (!this.triggerResult.wasSuccess()) continue;
            StackElement<CEExecutor> stackElement = new StackElement<CEExecutor>(CompetenceElement.class, ceExecutor.getName(), ceExecutor);
            return new FireResult(FireResult.Type.FOLLOW, stackElement);
        }
        return new FireResult(FireResult.Type.FAILED);
    }

    @Override
    public TriggerResult getTriggerResult() {
        return this.triggerResult;
    }
}

