/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PoshElement<T extends PoshElement, PARENT extends PoshElement> {
    private PARENT parent;
    private final Set<PoshElementListener<T>> elementListeners = new HashSet<PoshElementListener<T>>();
    private final Set<PoshElementListener<T>> elementListenersUm = Collections.unmodifiableSet(this.elementListeners);

    public final Set<PoshElementListener<T>> getElementListeners() {
        return this.elementListenersUm;
    }

    public final synchronized boolean addElementListener(PoshElementListener<T> listener) {
        return this.elementListeners.add(listener);
    }

    public final synchronized boolean removeElementListener(PoshElementListener<T> listener) {
        return this.elementListeners.remove(listener);
    }

    protected final synchronized void firePropertyChange(String name, Object o, Object n) {
        PoshElementListener[] listeners;
        for (PoshElementListener listener : listeners = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.propertyChange(new PropertyChangeEvent(this, name, o, n));
        }
    }

    public int getNumberOfChildInstances(Class searchedClass) {
        int numEl = 0;
        for (PoshElement node : this.getChildDataNodes()) {
            if (!node.getClass().equals(searchedClass)) continue;
            ++numEl;
        }
        return numEl;
    }

    public abstract DataFlavor getDataFlavor();

    public abstract List<? extends PoshElement> getChildDataNodes();

    protected final synchronized void emitChildNode(PoshElement emitedChild) {
        PoshElementListener[] listenersArray;
        for (PoshElementListener listener : listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.childElementAdded(this, emitedChild);
        }
    }

    protected final synchronized void emitChildMove(PoshElement childNode, int oldIndex, int newIndex) {
        PoshElementListener[] listenersArray;
        for (PoshElementListener listener : listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.childElementMoved(this, childNode, oldIndex, newIndex);
        }
    }

    protected final synchronized void emitChildDeleted(PoshElement child, int removedChildPosition) {
        PoshElementListener[] listenersArray;
        for (PoshElementListener listener : listenersArray = this.elementListenersUm.toArray(new PoshElementListener[0])) {
            listener.childElementRemoved(this, child, removedChildPosition);
        }
    }

    protected void setParent(PARENT parent) {
        this.parent = parent;
    }

    public PARENT getParent() {
        return this.parent;
    }

    public final PoshPlan getRootNode() {
        PoshElement<T, PARENT> cur = this;
        while (cur.getParent() != null) {
            cur = cur.getParent();
        }
        if (cur instanceof PoshPlan) {
            return (PoshPlan)cur;
        }
        return null;
    }

    public abstract boolean moveChild(int var1, PoshElement var2);

    protected final boolean isChildOfParent() {
        if (this.parent != null) {
            return ((PoshElement)this.parent).getChildDataNodes().contains(this);
        }
        return false;
    }
}

