/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.shady;

import cz.cuni.amis.pogamut.shady.Arg;
import cz.cuni.amis.pogamut.shady.ParseException;

class ArgChar
extends Arg<Character> {
    public ArgChar(char character) {
        super(Character.valueOf(character));
    }

    public static char unescape(String escapedChar) throws ParseException {
        if (escapedChar.length() == 0) {
            throw new ParseException("The string representing the escaped character must have legth > 0.");
        }
        StringBuilder sb = new StringBuilder(escapedChar);
        char result = ArgChar.parseCharacter(sb);
        if (sb.length() > 0) {
            throw new ParseException("There still are some unparsed characters remaining(" + sb.length() + "):" + sb.toString());
        }
        return result;
    }

    protected static char parseCharacter(StringBuilder sb) throws ParseException {
        char result = sb.charAt(0);
        sb.deleteCharAt(0);
        if (result == '\\') {
            Character parsed = ArgChar.parseEscapeSequence(sb);
            if (parsed == null) {
                throw new ParseException("Unable to unescape sequence:" + sb.toString());
            }
            result = parsed.charValue();
        }
        return result;
    }

    public static char parseCharacterListeral(String charLiteral) throws ParseException {
        StringBuilder sb = new StringBuilder(charLiteral);
        if (sb.charAt(0) != '\'') {
            throw new ParseException("Expecting ' at the start of " + charLiteral.toString());
        }
        sb.deleteCharAt(0);
        char result = ArgChar.parseCharacter(sb);
        if (sb.length() != 1) {
            throw new ParseException("Expecting exactly one character (single quote), but " + sb.length() + " characters remain:" + sb.toString());
        }
        if (sb.charAt(0) != '\'') {
            throw new ParseException("Expecting ending double quote, but got: " + sb.charAt(0));
        }
        return result;
    }

    protected static Character parseEscapeSequence(StringBuilder sb) {
        Character octal = ArgChar.parseOctal(sb);
        if (octal != null) {
            return octal;
        }
        Character simpleEscape = ArgChar.parseSingleEscape(sb);
        if (simpleEscape != null) {
            return simpleEscape;
        }
        Character unicode = ArgChar.parseUnicode(sb);
        if (unicode != null) {
            return unicode;
        }
        return null;
    }

    protected static Character parseOctal(StringBuilder sb) {
        String octal2;
        String octal3;
        if (sb.length() >= 3 && (octal3 = sb.substring(0, 3)).matches("[0-3][0-7][0-7]")) {
            sb.delete(0, 3);
            return Character.valueOf(Character.toChars(Integer.parseInt(octal3, 8))[0]);
        }
        if (sb.length() >= 2 && (octal2 = sb.substring(0, 2)).matches("[0-7][0-7]")) {
            sb.delete(0, 2);
            return Character.valueOf(Character.toChars(Integer.parseInt(octal2, 8))[0]);
        }
        String octal1 = sb.substring(0, 1);
        if (octal1.matches("[0-7]")) {
            sb.delete(0, 1);
            return Character.valueOf(Character.toChars(Integer.parseInt(octal1, 8))[0]);
        }
        return null;
    }

    protected static Character parseSingleEscape(StringBuilder sb) {
        char res;
        char ch = sb.charAt(0);
        switch (ch) {
            case 'b': {
                res = '\b';
                break;
            }
            case 't': {
                res = '\t';
                break;
            }
            case 'n': {
                res = '\n';
                break;
            }
            case 'f': {
                res = '\f';
                break;
            }
            case 'r': {
                res = '\r';
                break;
            }
            case '\"': {
                res = '\"';
                break;
            }
            case '\'': {
                res = '\'';
                break;
            }
            case '\\': {
                res = '\\';
                break;
            }
            default: {
                return null;
            }
        }
        sb.deleteCharAt(0);
        return Character.valueOf(res);
    }

    protected static Character parseUnicode(StringBuilder sb) {
        String regexp = "u+\\p{XDigit}\\p{XDigit}\\p{XDigit}\\p{XDigit}.*";
        if (sb.toString().matches(regexp)) {
            while (sb.charAt(0) == 'u') {
                sb.deleteCharAt(0);
            }
            String hexaString = sb.substring(0, 4);
            sb.delete(0, 4);
            return Character.valueOf(Character.toChars(Integer.parseInt(hexaString, 16))[0]);
        }
        return null;
    }
}

