/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SenseTest
extends Assert {
    private Sense sense;
    private String initialName = "initialSenseName";

    @Before
    public void setUp() {
        this.sense = LapElementsFactory.createSense((String)this.initialName);
    }

    @Test
    public void changeName() throws ParseException {
        String newName = "other";
        this.sense.parseSense(newName);
        SenseTest.assertEquals((Object)newName, (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.DEFAULT, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)Boolean.TRUE, (Object)this.sense.getOperand());
    }

    @Test
    public void fqn() throws ParseException {
        String fqn = "cz.cuni.Run4Ever";
        this.sense.parseSense(fqn);
        SenseTest.assertEquals((Object)fqn, (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.DEFAULT, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)Boolean.TRUE, (Object)this.sense.getOperand());
    }

    @Test
    public void nameAndValue() throws ParseException {
        String senseName = "cz.cuni.Run4Ever";
        int value = 52;
        String input = senseName + ' ' + value;
        this.sense.parseSense(input);
        SenseTest.assertEquals((Object)senseName, (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.DEFAULT, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)value, (Object)this.sense.getOperand());
    }

    @Test(expected=ParseException.class)
    public void fourTokens() throws ParseException {
        this.sense.parseSense("cz.cuni.Health > 90 point 2");
    }

    @Test
    public void sensePredicateBoolean() throws ParseException {
        String senseName = "cz.Running";
        Sense.Predicate predicate = Sense.Predicate.EQUAL;
        Boolean value = Boolean.TRUE;
        String input = senseName + ' ' + "True" + ' ' + predicate;
        this.sense.parseSense(input);
        SenseTest.assertEquals((Object)senseName, (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.EQUAL, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)value, (Object)this.sense.getOperand());
    }

    @Test
    public void senseBoolstringPredicate() throws ParseException {
        String senseName = "cz.Running";
        Sense.Predicate predicate = Sense.Predicate.EQUAL;
        Boolean value = Boolean.TRUE;
        String input = senseName + ' ' + "True" + ' ' + predicate;
        this.sense.parseSense(input);
        SenseTest.assertEquals((Object)senseName, (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.EQUAL, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)value, (Object)this.sense.getOperand());
    }

    @Test(expected=ParseException.class)
    public void nothing() throws ParseException {
        this.sense.parseSense("");
    }

    @Test(expected=ParseException.class)
    public void invalidSenseToken() throws ParseException {
        this.sense.parseSense("cz..cuni.4ever");
    }

    @Test(expected=ParseException.class)
    public void invalidName() throws ParseException {
        this.sense.parseSense("cz.cuni.4ever");
    }

    @Test(expected=ParseException.class)
    public void sensePredicateValue() throws ParseException {
        this.sense.parseSense("cz.cuni.Health > 90");
    }

    @Test
    public void senseStringPredicate() throws ParseException {
        this.sense.parseSense("cz.cuni.Health \"Hello World!\" > ");
        SenseTest.assertEquals((Object)"cz.cuni.Health", (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.GREATER, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)"Hello World!", (Object)this.sense.getOperand());
    }

    @Test
    public void senseDoublePredicate() throws ParseException {
        this.sense.parseSense("cz.cuni.Distance -8.14e+5 <=");
        SenseTest.assertEquals((Object)"cz.cuni.Distance", (Object)this.sense.getName());
        SenseTest.assertEquals((Object)Sense.Predicate.LOWER_OR_EQUAL, (Object)this.sense.getPredicate());
        SenseTest.assertEquals((Object)-814000.0, (Object)this.sense.getOperand());
    }

    @Test(expected=ParseException.class)
    public void wrongPredicate() throws ParseException {
        this.sense.parseSense("name 9 =!=");
    }
}

