package cz.cuni.amis.pogamut.sposh.engine;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

/**
 * Executor for AP.
 * If successfull, return specified result, otehrwise FAIL.
 * @author Honza
 */
@SuppressWarnings("unchecked")
class APExecutor extends AbstractExecutor implements ElementExecutor {
    private ActionPattern actionPattern;
    private PoshPlan plan;
    private int index = 0;
    private FireResult.Type result;

    /**
     * Create a new AP executor
     * @param plan plan, we will use it to look up what are actions in ap
     * @param ap ap that will be executed.
     * @param result what to return in case of successful AP execution (SURFACE or FULFILLED)
     * @param ctx
     * @param log logger to record actions of this executor, can be null
     */
    APExecutor(PoshPlan plan, ActionPattern ap, FireResult.Type result, VariableContext ctx, Logger log) {
        super(ctx, log);

        this.result = result;
        this.index = 0;

        this.plan = plan;
        this.actionPattern = ap;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (index == actionPattern.getActions().size()) {
            return new FireResult(result);
        }
        // index is not incremented here, it should be done only whenever the action finishes its execution,
        // see createActionExecutor()
        TriggeredAction action = actionPattern.getActions().get(index);
        StackElement stackElement = createActionExecutor(plan, action.getActionCall());
        return new FireResult(FireResult.Type.FOLLOW, stackElement);
    }

    /**
     * Create an executor for the passed action according to what it really is (C/AP/P).
     * @param plan
     * @param action
     * @return
     */    
	private StackElement createActionExecutor(PoshPlan plan, PrimitiveCall actionCall) {
		StackElement element = getElement(plan, actionCall, 
						  FireResult.Type.SURFACE_CONTINUE, 
						  FireResult.Type.SURFACE,
						  FireResult.Type.SURFACE,
						  FireResult.Type.FAILED,
			              new Runnable() { // FINISHED CALLBACK
							@Override
							public void run() {
								++index;
							}
			              },
		                  null,
		                  new Runnable() { // RUNNING ONCE CALLBACK
							@Override
							public void run() {
								++index;
							}
			              },
		                  null
				);        
		if (element.getExecutor() instanceof APExecutor) {
			// APExecutor won't trigger SUCCESS-CALLBACK ... must manually move index of next-to-be-executed action
			++index;
		}
		return element;
    }

    /**
     * AP has no triggers so return satisfied trigger
     * @return 
     */
    @Override
    public TriggerResult getTriggerResult() {
        // XXX: Is it ok to always create new instance, maybe static field would be better
        return new TriggerResult(true);
    }
}
