package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace.StackElement;
import java.util.Stack;

/**
 * Callstack used for storing info what was call hiearchy of elements.
 *
 * @author Honza
 */
final public class ElementStackTrace extends Stack<StackElement>   {

    /**
     * One level in callstack.
     */
    final static class StackElement<T extends ElementExecutor> {

        private String name;
        private Class clazz;
        private T executor;

        StackElement(Class clazz, String name, T executor) {
            this.clazz = clazz;
            this.name = name;
            this.executor = executor;
        }

        @Override
        public String toString() {
            return "StackElement[" + clazz.getSimpleName() + ":" + name + ":" + executor + "]";
        }


        T getExecutor() {
            return executor;
        }
    }

    public synchronized void  printStackTrace() {
        System.out.println("ElementStackTrace:");
        for (StackElement element : this) {
            System.out.println(element);
        }
    }
}
