/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class SenseListExecutor
extends AbstractExecutor {
    private List<SenseExecutor> sensesExecutors = new ArrayList<SenseExecutor>();

    SenseListExecutor(Goal goal, VariableContext ctx, Logger log) {
        super(ctx, log);
        if (goal == null) {
            return;
        }
        for (Sense sense : goal.getSenses()) {
            this.sensesExecutors.add(new SenseExecutor(sense, ctx, log));
        }
    }

    SenseListExecutor(Triggers triggers, VariableContext ctx, Logger log) {
        super(ctx, log);
        if (triggers == null) {
            return;
        }
        for (Sense sense : triggers.getSenses()) {
            this.sensesExecutors.add(new SenseExecutor(sense, ctx, log));
        }
    }

    SenseListExecutor(List<Sense> triggers, VariableContext ctx, Logger log) {
        super(ctx, log);
        for (Sense sense : triggers) {
            this.sensesExecutors.add(new SenseExecutor(sense, ctx, log));
        }
    }

    public boolean fire(IWorkExecutor workExecuter, boolean defaultReturn) {
        for (SenseExecutor senseExecutor : this.sensesExecutors) {
            defaultReturn = true;
            if (senseExecutor.fire(workExecuter)) continue;
            return false;
        }
        return defaultReturn;
    }
}

