/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.DocString;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class PoshPlan
extends PoshDummyElement {
    private DocString _docstring = null;
    private DriveCollection _driveCollection = null;
    private List<ActionPattern> _actionPatterns = new ArrayList<ActionPattern>();
    private List<Competence> _competences = new ArrayList<Competence>();
    private String name = null;
    public static final String prName = "prName";
    public static final DataFlavor dataFlavor = new DataFlavor(PoshPlan.class, "posh_tree_root");
    private Set<PoshElementListener> globalListeners = new HashSet<PoshElementListener>();

    public PoshPlan() {
        this.name = "";
    }

    public PoshPlan(String name) {
        this.name = name;
    }

    public boolean isC(String name) {
        return this.getC(name) != null;
    }

    public Competence getC(String name) {
        for (Competence c : this.getCompetences()) {
            if (!c.getNodeName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public boolean isAP(String name) {
        return this.getAP(name) != null;
    }

    public ActionPattern getAP(String name) {
        for (ActionPattern ap : this.getActionPatterns()) {
            if (!ap.getNodeName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    public boolean isUniqueAPorComp(String id) {
        for (ActionPattern actionPattern : this._actionPatterns) {
            if (!actionPattern.getNodeName().equals(id)) continue;
            return false;
        }
        for (Competence competence : this._competences) {
            if (!competence.getNodeName().equals(id)) continue;
            return false;
        }
        return true;
    }

    private void refreshActions() {
        LinkedList<TriggeredAction> actions = new LinkedList<TriggeredAction>();
        List<ActionPattern> aps = this.getActionPatterns();
        List<Competence> competences = this.getCompetences();
        for (ActionPattern ap : aps) {
            for (TriggeredAction action : ap.getTriggeredActions()) {
                actions.add(action);
            }
        }
        for (Competence competence : competences) {
            for (CompetencePriorityElement cpe : competence.getPriorityElements()) {
                for (CompetenceElement ce : cpe.getElements()) {
                    actions.add(ce.getAction());
                }
            }
        }
        if (this.getDriveCollection() != null) {
            for (DrivePriorityElement dpe : this.getDriveCollection().getPriorityElements()) {
                for (DriveElement de : dpe.getDriveElements()) {
                    actions.add(de.getTriggeredAction());
                }
            }
        }
        for (TriggeredAction action : actions) {
            action.setActionName(action.getActionName());
        }
    }

    public void setDocString(DocString docstring) {
        docstring.setParent(this);
        if (this._docstring != null) {
            this._docstring.remove();
        }
        this._docstring = docstring;
        this.emitChildNode(this._docstring);
    }

    public void addCompetence(Competence competence) throws ParseException {
        if (!this.isUniqueAPorComp(competence.getNodeName())) {
            throw new ParseException("Competence  '" + competence.getNodeName() + "' has duplicate name in POSH plan.");
        }
        competence.setParent(this);
        this._competences.add(competence);
        if (this.isCycled()) {
            this._competences.remove(competence);
            throw new ParseException("Competence " + competence.getNodeName() + " is causing cycle.");
        }
        this.emitChildNode(competence);
        this.refreshActions();
    }

    public List<Competence> getCompetences() {
        return Collections.unmodifiableList(this._competences);
    }

    public void addActionPattern(ActionPattern actionPattern) throws ParseException {
        if (!this.isUniqueAPorComp(actionPattern.getNodeName())) {
            throw new ParseException("Action pattern '" + actionPattern.getNodeName() + "' has duplicate name in POSH plan.");
        }
        actionPattern.setParent(this);
        this._actionPatterns.add(actionPattern);
        if (this.isCycled()) {
            this._actionPatterns.remove(actionPattern);
            throw new ParseException("Action pattern '" + actionPattern.getNodeName() + "' is causing cycle.");
        }
        this.emitChildNode(actionPattern);
        this.refreshActions();
    }

    public List<ActionPattern> getActionPatterns() {
        return Collections.unmodifiableList(this._actionPatterns);
    }

    protected void setDriveCollection(DriveCollection dc) {
        dc.setParent(this);
        if (this._driveCollection != null) {
            this._driveCollection.remove();
        }
        this._driveCollection = dc;
        this.emitChildNode(this._driveCollection);
    }

    public DriveCollection getDriveCollection() {
        return this._driveCollection;
    }

    public boolean isCycled() {
        for (ActionPattern apNode : this._actionPatterns) {
            if (!this.findCycle(apNode, new HashSet<String>())) continue;
            return true;
        }
        for (Competence compNode : this._competences) {
            if (!this.findCycle(compNode, new HashSet<String>())) continue;
            return true;
        }
        return false;
    }

    private boolean findCycle(ActionPattern apNode, Set<String> set) {
        if (set.contains(apNode.getNodeName())) {
            return true;
        }
        set.add(apNode.getNodeName());
        for (TriggeredAction action : apNode._actions) {
            ActionPattern actionAP = this.getAP(action.getActionName());
            if (actionAP != null && this.findCycle(actionAP, set)) {
                return true;
            }
            Competence actionComp = this.getC(action.getActionName());
            if (actionComp == null || !this.findCycle(actionComp, set)) continue;
            return true;
        }
        set.remove(apNode.getNodeName());
        return false;
    }

    private boolean findCycle(Competence compNode, Set<String> set) {
        if (set.contains(compNode.getNodeName())) {
            return true;
        }
        set.add(compNode.getNodeName());
        if (compNode.getPriorityElements() == null) {
            set.remove(compNode.getNodeName());
            return false;
        }
        for (CompetencePriorityElement cElem : compNode.getPriorityElements()) {
            for (CompetenceElement cAtom : cElem.competenceElements) {
                TriggeredAction action = cAtom.getAction();
                ActionPattern actionAP = this.getAP(action.getActionName());
                if (actionAP != null && this.findCycle(actionAP, set)) {
                    return true;
                }
                Competence actionComp = this.getC(action.getActionName());
                if (actionComp == null || !this.findCycle(actionComp, set)) continue;
                return true;
            }
        }
        set.remove(compNode.getNodeName());
        return false;
    }

    protected List<String> getAPorCompActions(String ident) {
        ActionPattern ap = this.getAP(ident);
        if (ap != null) {
            LinkedList<String> actionList = new LinkedList<String>();
            for (TriggeredAction a : ap._actions) {
                actionList.add(a.getActionName());
            }
            return actionList;
        }
        Competence cn = this.getC(ident);
        if (cn != null) {
            LinkedList<String> actionList = new LinkedList<String>();
            for (CompetencePriorityElement ce : cn.getPriorityElements()) {
                for (CompetenceElement ca : ce.competenceElements) {
                    if (ca.getAction() == null) continue;
                    actionList.add(ca.getAction().getActionName());
                }
            }
            return actionList;
        }
        return new LinkedList<String>();
    }

    public String toString() {
        String ret = "(";
        if (this._docstring != null) {
            ret = ret + "\n" + this._docstring.toString();
        }
        for (Competence competence : this._competences) {
            ret = ret + "\n" + competence.toString();
        }
        for (ActionPattern actionPattern : this._actionPatterns) {
            ret = ret + "\n" + actionPattern.toString();
        }
        if (this._driveCollection != null) {
            ret = ret + "\n" + this._driveCollection.toString();
        }
        ret = ret + "\n)";
        return ret;
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>();
        if (this._docstring != null) {
            children.add(this._docstring);
        }
        for (Competence competence : this._competences) {
            children.add(competence);
        }
        for (ActionPattern actionPattern : this._actionPatterns) {
            children.add(actionPattern);
        }
        if (this._driveCollection != null) {
            children.add(this._driveCollection);
        }
        return children;
    }

    public void setTreeName(String newName) {
        this.name = newName;
        this.firePropertyChange(prName, null, newName);
    }

    public String getTreeName() {
        return this.name;
    }

    public synchronized void removeListenersFromTree(PoshElementListener listener) {
        this.getRootNode().removeListenersFromTree(this, listener);
    }

    protected synchronized void removeListenersFromTree(PoshElement node, PoshElementListener listener) {
        node.removePoshTreeChangeListener(listener);
        for (PoshElement child : node.getChildDataNodes()) {
            this.removeListenersFromTree(child, listener);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getTreeName();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        if (this._competences.contains(child)) {
            return this.moveNodeInList(this._competences, child, relativePosition);
        }
        if (this._actionPatterns.contains(child)) {
            return this.moveNodeInList(this._actionPatterns, child, relativePosition);
        }
        return false;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) throws ParseException {
        if (newChild instanceof DocString) {
            this.setDocString((DocString)newChild);
        } else if (newChild instanceof Competence) {
            this.addCompetence((Competence)newChild);
        } else if (newChild instanceof ActionPattern) {
            this.addActionPattern((ActionPattern)newChild);
        } else if (newChild instanceof DriveCollection) {
            this.setDriveCollection((DriveCollection)newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._docstring == childNode) {
            this._docstring = null;
            childNode.remove();
        } else if (this._competences.contains(childNode)) {
            this._competences.remove(childNode);
            childNode.remove();
        } else if (this._actionPatterns.contains(childNode)) {
            this._actionPatterns.remove(childNode);
            childNode.remove();
        } else if (this._driveCollection == childNode) {
            this._driveCollection = null;
            childNode.remove();
        }
    }

    public void emitTree() {
        for (PoshElement pe : this.getChildDataNodes()) {
            this.emitChildNode(pe);
        }
    }

    synchronized void treeChanged(PoshTreeEvent event, PoshElement child) {
        for (PoshElementListener globalListener : this.globalListeners) {
            globalListener.nodeChanged(event, child);
        }
    }

    public synchronized void addGlobalTreeListener(PoshElementListener l) {
        assert (l != null);
        this.globalListeners.add(l);
        this.addPropertyChangeListener(l);
    }

    public synchronized void removeGlobalTreeListener(PoshElementListener l) {
        assert (l != null);
        this.globalListeners.remove(l);
        this.removePropertyChangeListener(l);
    }

    synchronized void treePropertyChanged(PropertyChangeEvent event) {
        for (PoshElementListener globalListener : this.globalListeners) {
            globalListener.propertyChange(event);
        }
    }
}

