/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class PrimitiveExecutor
extends AbstractExecutor
implements ElementExecutor {
    private final Sense.SenseCall actionCall;
    private final FireResult.Type successResult;
    private final FireResult.Type failResult;

    PrimitiveExecutor(Sense.SenseCall actionCall, VariableContext ctx, Logger log) {
        this(actionCall, FireResult.Type.SURFACE, FireResult.Type.SURFACE, ctx, log);
    }

    PrimitiveExecutor(Sense.SenseCall actionCall, FireResult.Type successResult, FireResult.Type failResult, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.actionCall = actionCall;
        this.successResult = successResult;
        this.failResult = failResult;
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        Object result = workExecuter.executePrimitive(this.actionCall.getName(), this.ctx);
        if (Result.isFalse(result)) {
            return new FireResult(this.failResult);
        }
        return new FireResult(this.successResult);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.actionCall.getName() + "]";
    }
}

