/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.DCExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

public class PoshEngine {
    protected PoshPlan plan;
    protected ITimer timer;
    protected Logger log;
    private DCExecutor dcExecutor;

    public PoshEngine(PoshPlan plan) {
        this(plan, new SystemClockTimer());
    }

    public PoshEngine(PoshPlan plan, ITimer timer) {
        this(plan, timer, null);
    }

    public PoshEngine(PoshPlan plan, ITimer timer, Logger log) {
        this.plan = plan;
        this.timer = timer;
        this.log = log;
        this.reset();
    }

    public final synchronized void reset() {
        this.dcExecutor = new DCExecutor(this.plan, new VariableContext(), this.timer, this.log);
    }

    public synchronized EvaluationResult evaluatePlan(IWorkExecutor workExecuter) {
        return this.dcExecutor.fire(workExecuter);
    }

    ElementStackTrace getStackForDE(String name) {
        return this.dcExecutor.getStackForDE(name);
    }

    ElementStackTrace getStackForDE(int index) {
        return this.dcExecutor.getStackForDE(index);
    }

    public static enum EvaluationResult {
        GOAL_SATISFIED,
        ELEMENT_FIRED,
        NO_ELEMENT_FIRED;

    }
}

