/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.APExecutor;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PrimitiveExecutor;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.logging.Logger;

class DEExecutor
extends AbstractExecutor {
    private String name;
    private PoshPlan plan;
    private Sense.SenseCall actionCall;
    private SenseListExecutor trigger;
    private Freq freq;
    private long lastFired = Integer.MAX_VALUE;
    private ElementStackTrace stackTrace = new ElementStackTrace();

    DEExecutor(PoshPlan plan, DriveElement de, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.trigger = new SenseListExecutor(de.getTriggers(), ctx, log);
        this.freq = new Freq(de.getFreq());
        this.name = de.getDriveName();
        this.plan = plan;
        this.actionCall = de.getTriggeredAction().getActionCall();
    }

    private ElementStackTrace.StackElement createInitialStackElement(PoshPlan plan, Sense.SenseCall actionCall) {
        String apname = actionCall.getName();
        for (ActionPattern ap : plan.getActionPatterns()) {
            if (!apname.equals(ap.getNodeName())) continue;
            APExecutor newAPExecutor = new APExecutor(plan, ap, FireResult.Type.SURFACE, new VariableContext(this.ctx, actionCall.getParameters(), ap.getParameters()), this.log);
            return new ElementStackTrace.StackElement<APExecutor>(ActionPattern.class, apname, newAPExecutor);
        }
        for (Competence c : plan.getCompetences()) {
            if (!apname.equals(c.getNodeName())) continue;
            return new ElementStackTrace.StackElement<CExecutor>(Competence.class, apname, new CExecutor(plan, c, new VariableContext(this.ctx, actionCall.getParameters(), c.getParameters()), this.log));
        }
        return new ElementStackTrace.StackElement<PrimitiveExecutor>(TriggeredAction.class, apname, new PrimitiveExecutor(actionCall, new VariableContext(this.ctx, actionCall.getParameters()), this.log));
    }

    public synchronized boolean isReady(long timestamp, IWorkExecutor workExecuter) {
        long passed = timestamp - this.lastFired;
        if (Freq.compare(this.freq.tick(), passed) > 0) {
            this.info("Max.firing frequency exceeded, has to be at least " + this.freq.tick() + "ms, but was only " + passed);
            return false;
        }
        return this.trigger.fire(workExecuter, true);
    }

    public synchronized void fire(IWorkExecutor workExecuter, ITimer timer) {
        if (this.stackTrace.isEmpty()) {
            this.stackTrace.add(this.createInitialStackElement(this.plan, this.actionCall));
            return;
        }
        FireResult result = ((ElementStackTrace.StackElement)this.stackTrace.peek()).getExecutor().fire(workExecuter);
        this.lastFired = timer.getTime();
        this.info("The fired element returned: " + (Object)((Object)result.getType()));
        switch (result.getType()) {
            case FULFILLED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FAILED: {
                this.stackTrace.removeAllElements();
                break;
            }
            case FOLLOW: {
                this.stackTrace.push(result.getNextElement());
                break;
            }
            case CONTINUE: {
                break;
            }
            case SURFACE: {
                this.stackTrace.pop();
                break;
            }
            default: {
                throw new IllegalStateException("State \"" + (Object)((Object)result.getType()) + "\" not expected. Serious error.");
            }
        }
    }

    ElementStackTrace getStackTrace() {
        return this.stackTrace;
    }

    public String getName() {
        return this.name;
    }
}

