/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.DEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class DCExecutor
extends AbstractExecutor {
    private SenseListExecutor goalExecutor;
    private List<DEExecutor> deExecutors = new ArrayList<DEExecutor>();
    private ITimer timer;

    protected DCExecutor(PoshPlan plan, VariableContext ctx) {
        this(plan, ctx, new SystemClockTimer(), null);
    }

    protected DCExecutor(PoshPlan plan, VariableContext ctx, ITimer timer, Logger log) {
        super(ctx, log);
        DriveCollection dc = plan.getDriveCollection();
        this.timer = timer;
        this.goalExecutor = new SenseListExecutor(dc.getGoal(), ctx, log);
        for (DrivePriorityElement dpe : dc.getPriorityElements()) {
            for (DriveElement de : dpe.getDriveElements()) {
                this.deExecutors.add(new DEExecutor(plan, de, ctx, log));
            }
        }
    }

    public synchronized PoshEngine.EvaluationResult fire(IWorkExecutor workExecuter) {
        if (this.goalExecutor.fire(workExecuter, false)) {
            return PoshEngine.EvaluationResult.GOAL_SATISFIED;
        }
        for (DEExecutor deExecutor : this.deExecutors) {
            if (!deExecutor.isReady(this.timer.getTime(), workExecuter)) continue;
            deExecutor.fire(workExecuter, this.timer);
            return PoshEngine.EvaluationResult.ELEMENT_FIRED;
        }
        return PoshEngine.EvaluationResult.NO_ELEMENT_FIRED;
    }

    ElementStackTrace getStackForDE(int index) {
        return this.deExecutors.get(index).getStackTrace();
    }

    ElementStackTrace getStackForDE(String name) {
        DEExecutor result = null;
        for (DEExecutor de : this.deExecutors) {
            boolean bl = de.getName() == null ? name == null : de.getName().equals(name);
            boolean equal = bl;
            if (!equal) continue;
            if (result == null) {
                result = de;
                continue;
            }
            throw new IllegalStateException("Two drive elements with name \"" + name + "\".");
        }
        if (result != null) {
            return result.getStackTrace();
        }
        return null;
    }
}

