/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Freq;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

public class DriveElement
extends PoshDummyElement {
    private String _name;
    private Triggers _triggers;
    private TriggeredAction _action;
    private Freq _freq;
    private String comment;
    public static final String deName = "deName";
    public static final String deFreqNum = "deFreqNum";
    public static final String deFreqUnits = "deFreqUnits";
    public static final String deComment = "deComment";
    public static final DataFlavor dataFlavor = new DataFlavor(DriveElement.class, "drive-element");

    public DriveElement(String name, Triggers triggers, String actionName, Freq freq) {
        this(name, triggers, actionName, freq, null);
    }

    public DriveElement(String name, Triggers triggers, String actionName, Freq freq, String comment) {
        this(name, triggers, new Sense.SenseCall(actionName), freq, comment);
    }

    public DriveElement(String name, Triggers triggers, Sense.SenseCall actionCall, Freq freq, String comment) {
        this._name = name;
        this._triggers = triggers;
        this._action = new TriggeredAction(actionCall);
        this._freq = freq;
        if (this._freq == null) {
            this._freq = new Freq();
        }
        this._action.setParent(this);
        this._triggers.setParent(this);
        this.comment = comment;
    }

    public Triggers getTriggers() {
        return this._triggers;
    }

    public TriggeredAction getTriggeredAction() {
        return this._action;
    }

    public void setTriggeredAction(TriggeredAction action) {
        this._action.remove();
        this._action = action;
        this._action.setParent(this);
        this.emitChildNode(this._action);
    }

    public String toString() {
        String res = this._triggers.getChildDataNodes().size() == 0 ? "(" + this._name + " " + this._action.toString() : "(" + this._name + " (trigger " + this._triggers.toString() + ") " + this._action.toString();
        if (this._freq != null) {
            res = res + " " + this._freq.toString();
        }
        if (this.comment != null) {
            res = res + " \"" + this.comment + "\"";
        }
        return res + ")";
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>();
        children.add(this._triggers);
        children.add(this._action);
        return children;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDriveName() {
        return this._name;
    }

    public void setDriveName(String name) {
        if ((name = name.trim()).matches("[_a-zA-Z][_\\-a-zA-Z0-9]*")) {
            this._name = name;
            this.firePropertyChange(deName, null, name);
        }
    }

    public Freq getFreq() {
        return new Freq(this._freq);
    }

    public Double getFreqNum() {
        return new Double(this._freq.getAmmount());
    }

    public void setFreqNum(Double newNum) {
        if (newNum != null) {
            this._freq.setAmmount(newNum);
            this.firePropertyChange(deFreqNum, null, newNum);
        }
    }

    public Integer getFreqUnits() {
        return this._freq.getUnits().getId();
    }

    public void setFreqUnits(Integer newUnitsId) {
        if (newUnitsId != null) {
            for (Freq.FreqUnits unit : Freq.FreqUnits.values()) {
                if (unit.getId() != newUnitsId.intValue()) continue;
                this._freq.setUnits(unit);
                this.firePropertyChange(deFreqUnits, null, (Object)unit);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.getDriveName();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return false;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (!(newChild instanceof TriggeredAction)) {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
        this.setTriggeredAction((TriggeredAction)newChild);
    }

    private void setTriggers(Triggers newTriggers) {
        newTriggers.setParent(this);
        this._triggers.remove();
        this._triggers = newTriggers;
        this.emitChildNode(this._triggers);
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._action == childNode) {
            this.setTriggeredAction(new TriggeredAction("do_nothing"));
        } else if (this._triggers == childNode) {
            this.setTriggers(new Triggers(new Sense("succeed")));
        }
    }
}

