package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Sense.Predicate;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Honza
 */
public class SenseExecutorTest {

    public SenseExecutorTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }


    /**
     * Test of evaluateComparison method, of class SenseExecutor.
     */
    @Test
    public void testEvaluateComparison() {
        System.out.println("evaluateComparison");
        SenseExecutor exec = new SenseExecutor(new Sense("dummy"), new VariableContext(), null);

        assertTrue(exec.evaluateComparison(true, Predicate.EQUAL, true));
        assertTrue(exec.evaluateComparison(1, Predicate.EQUAL, true));
        assertTrue(exec.evaluateComparison(false, Predicate.EQUAL, false));
        assertTrue(exec.evaluateComparison(false, Predicate.EQUAL, 0));
        assertTrue(exec.evaluateComparison(null, Predicate.EQUAL, null));

        assertFalse(exec.evaluateComparison(-23.5, Predicate.EQUAL, true));
        assertFalse(exec.evaluateComparison(6, Predicate.EQUAL, true));
        assertFalse(exec.evaluateComparison(0, Predicate.EQUAL, 1));
        assertFalse(exec.evaluateComparison(null, Predicate.EQUAL, "Ahoj"));

        assertTrue(exec.evaluateComparison("aa", Predicate.EQUAL, "aa"));
        assertFalse(exec.evaluateComparison("aa", Predicate.EQUAL, "aA"));

        assertTrue(exec.evaluateComparison("aa", Predicate.LOWER,"ab"));
        assertTrue(exec.evaluateComparison("cecialia", Predicate.GREATER_OR_EQUAL,"adam"));

        assertTrue(exec.evaluateComparison(true, Predicate.GREATER_OR_EQUAL,false));
        assertTrue(exec.evaluateComparison(true, Predicate.GREATER,false));
        assertFalse(exec.evaluateComparison(true, Predicate.EQUAL,false));

        assertTrue(exec.evaluateComparison(true, Predicate.GREATER,-1));
        assertTrue(exec.evaluateComparison(false, Predicate.GREATER,-1));

        assertTrue(exec.evaluateComparison(12, Predicate.LOWER,22.0));
    }

}