/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class BehaviorWorkExecutor
implements IWorkExecutor {
    protected final HashMap<String, BehaviorMethod> primitives = new HashMap();

    public BehaviorWorkExecutor() {
    }

    public BehaviorWorkExecutor(Object behavior) {
        this.addBehavior(behavior);
    }

    public synchronized void addBehavior(Object behavior) {
        Method[] methods;
        for (Method method : methods = behavior.getClass().getMethods()) {
            boolean isAnnotated = method.isAnnotationPresent(SPOSHAction.class) || method.isAnnotationPresent(SPOSHSense.class);
            String name = method.getName();
            if (!isAnnotated) continue;
            if (this.primitives.containsKey(name)) {
                throw new IllegalArgumentException("primitive name clash (there are at least 2 primitives with name \"" + name + "\")");
            }
            this.primitives.put(name, new BehaviorMethod(behavior, method));
        }
    }

    @Override
    public Object executePrimitive(String primitive, VariableContext ctx) {
        Class<?> firstParameterClass;
        BehaviorMethod behaviorMethod = this.primitives.get(primitive);
        if (behaviorMethod == null) {
            throw new IllegalArgumentException("Primitive \"" + primitive + "\" has no behavior method.");
        }
        Method method = behaviorMethod.method;
        Object[] args = new Object[method.getParameterTypes().length];
        if (method.getParameterTypes().length > 0 && (firstParameterClass = method.getParameterTypes()[0]).equals(VariableContext.class)) {
            args[0] = ctx;
        }
        try {
            return method.invoke(behaviorMethod.behavior, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    protected class BehaviorMethod {
        public final Object behavior;
        public final Method method;

        public BehaviorMethod(Object behavior, Method method) {
            this.behavior = behavior;
            this.method = method;
        }
    }
}

