/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.CEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class CExecutor
extends AbstractExecutor
implements ElementExecutor {
    private SenseListExecutor goalExecutor;
    private List<CEExecutor> ceExecutors = new ArrayList<CEExecutor>();

    public CExecutor(PoshPlan plan, Competence c, VariableContext ctx, Logger log) {
        super(ctx, log);
        this.goalExecutor = new SenseListExecutor(c.getGoal(), ctx, log);
        for (CompetencePriorityElement cpe : c.getPriorityElements()) {
            for (CompetenceElement ce : cpe.getElements()) {
                this.ceExecutors.add(new CEExecutor(plan, ce, ctx, log));
            }
        }
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        if (this.goalExecutor.fire(workExecuter, false)) {
            return new FireResult(FireResult.Type.FULFILLED);
        }
        for (CEExecutor ceExecutor : this.ceExecutors) {
            if (!ceExecutor.isReady(workExecuter)) continue;
            ElementStackTrace.StackElement<CEExecutor> stackElement = new ElementStackTrace.StackElement<CEExecutor>(CompetenceElement.class, ceExecutor.getName(), ceExecutor);
            return new FireResult(FireResult.Type.FOLLOW, stackElement);
        }
        return new FireResult(FireResult.Type.FAILED);
    }
}

