/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public final class FormalParameters
extends AbstractList<Parameter> {
    private List<Parameter> parameters = new ArrayList<Parameter>();

    FormalParameters(FormalParameters parameters) {
        for (Parameter param : parameters) {
            this.add(param);
        }
    }

    protected FormalParameters() {
    }

    @Override
    public Parameter get(int index) {
        return this.parameters.get(index);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Parameter set(int index, Parameter element) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(element.getName()) || param.equals(element)) continue;
            throw new IllegalArgumentException("Parameter with name \"" + element.getName() + "\" has already been specified in formal parameters.");
        }
        return this.parameters.set(index, element);
    }

    @Override
    public void add(int index, Parameter element) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(element.getName())) continue;
            throw new IllegalArgumentException("Parameter with name \"" + element.getName() + "\" has already been specified in formal parameters.");
        }
        this.parameters.add(index, element);
    }

    @Override
    public Parameter remove(int index) {
        return this.parameters.remove(index);
    }

    public boolean containsVariable(String variableName) {
        for (Parameter param : this.parameters) {
            if (!param.getName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < this.parameters.size(); ++i) {
            String parameterName = this.parameters.get(i).toString();
            if (i == 0) {
                sb.append(parameterName);
                continue;
            }
            sb.append(", " + parameterName);
        }
        return sb.toString();
    }

    public static final class Parameter {
        private final String name;
        private final Object defaultValue;

        protected Parameter(String name, Object defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.getName() + "=" + this.getDefaultValue();
        }
    }
}

