/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.SlotEnvelope;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;

final class ChoicesPresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<Competence> {
    private final ShedChoicesEnvelope choicesEnvelope;
    private final Competence competence;
    private final LapChain chain;

    ChoicesPresenter(ShedScene scene, ShedPresenter presenter, ShedChoicesEnvelope choicesEnvelope, Competence competence, LapChain competenceChain) {
        super(scene, presenter);
        this.choicesEnvelope = choicesEnvelope;
        this.competence = competence;
        this.chain = competenceChain;
    }

    @Override
    public void register() {
        this.choicesEnvelope.setPresenter(this);
        this.competence.addElementListener((PoshElementListener)this);
    }

    @Override
    public void unregister() {
        this.competence.removeElementListener((PoshElementListener)this);
        this.choicesEnvelope.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void childElementAdded(Competence parent, PoshElement child) {
        if (!this.isChoice(child)) {
            throw new IllegalArgumentException();
        }
        Anchor envelopeAnchor = this.choicesEnvelope.getCommonAnchor();
        List choices = parent.getChildDataNodes();
        CompetenceElement choice = this.extractChoice(choices, child);
        int choicePosition = this.getPosition(choices, choice);
        LapPath competencePath = this.chain.toPath();
        LapPath choicePath = competencePath.concat(LapType.COMPETENCE_ELEMENT, choicePosition);
        ShedCreationContainer<SlotEnvelope> choiceContainer = this.scene.getWidgetFactory().createChoiceEnvelope(choicePath, choice, envelopeAnchor);
        this.choicesEnvelope.add(choiceContainer.getWidget(), choicePosition);
        this.scene.update();
        this.scene.addArrows(choiceContainer.getArrows());
        this.scene.update();
    }

    public void childElementMoved(Competence parent, PoshElement child, int oldIndex, int newIndex) {
        if (!this.isChoice(child)) {
            throw new IllegalArgumentException();
        }
        SlotEnvelope choiceWidget = (SlotEnvelope)((Object)this.choicesEnvelope.getChild(oldIndex));
        this.choicesEnvelope.move(newIndex, choiceWidget);
        this.scene.update();
    }

    public void childElementRemoved(Competence parent, PoshElement child, int removedChildIndex) {
        if (!this.isChoice(child)) {
            throw new IllegalArgumentException();
        }
        SlotEnvelope removedChoiceWidget = (SlotEnvelope)((Object)this.choicesEnvelope.getChild(removedChildIndex));
        this.choicesEnvelope.remove(removedChoiceWidget);
        this.scene.update();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }
}

