/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveData;
import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.CrawlerFactory;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import cz.cuni.pogamut.posh.explorer.Explorer;
import cz.cuni.pogamut.posh.explorer.IActionCrawler;
import cz.cuni.pogamut.posh.explorer.IExplorerActions;
import cz.cuni.pogamut.posh.explorer.IPaletteActions;
import cz.cuni.pogamut.posh.explorer.ISenseCrawler;
import cz.cuni.pogamut.posh.explorer.PGSupport;
import cz.cuni.pogamut.shed.NewPrimitiveWizardIterator;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.ExTransferable;

public final class ExplorerFactory {
    private ExplorerFactory() {
    }

    public static Explorer<PrimitiveData> createActionsExplorer(IPaletteActions paletteActions, Project project, CrawlerListener<PrimitiveData> ... listeners) {
        IActionCrawler crawler = new IActionCrawler(project);
        Explorer<PrimitiveData> explorer = new Explorer<PrimitiveData>(paletteActions, new ActionsExplorerActions(crawler, project));
        crawler.addListener(explorer);
        for (CrawlerListener<PrimitiveData> listener : listeners) {
            crawler.addListener(listener);
        }
        crawler.crawl();
        return explorer;
    }

    public static Explorer<PrimitiveData> createSensesExplorer(IPaletteActions paletteActions, Project project, CrawlerListener<PrimitiveData> ... listeners) {
        ISenseCrawler crawler = new ISenseCrawler(project);
        Explorer<PrimitiveData> explorer = new Explorer<PrimitiveData>(paletteActions, new SensesExplorerActions(crawler, project));
        crawler.addListener(explorer);
        for (CrawlerListener<PrimitiveData> listener : listeners) {
            crawler.addListener(listener);
        }
        crawler.crawl();
        return explorer;
    }

    public static Explorer<Competence> createCompetenceExplorer(IPaletteActions paletteActions, PoshPlan plan) {
        Crawler<Competence> crawler = CrawlerFactory.createCompetenceCrawler(plan);
        Explorer<Competence> explorer = new Explorer<Competence>(paletteActions, new CompetenceExplorerActions(plan, crawler));
        crawler.addListener(explorer);
        crawler.crawl();
        return explorer;
    }

    public static Explorer<ActionPattern> createAPExplorer(IPaletteActions paletteActions, PoshPlan lapTree) {
        Crawler<ActionPattern> crawler = CrawlerFactory.createAPCrawler(lapTree);
        Explorer<ActionPattern> explorer = new Explorer<ActionPattern>(paletteActions, new APExplorerActions(lapTree, crawler));
        crawler.addListener(explorer);
        crawler.crawl();
        return explorer;
    }

    static final class NodeTransferable<NODE extends PoshElement>
    extends ExTransferable.Single {
        private NODE dataNode;

        NodeTransferable(NODE dataNode) {
            super(dataNode.getDataFlavor());
            this.dataNode = dataNode;
        }

        protected NODE getData() {
            return this.dataNode;
        }
    }

    static final class APExplorerActions
    extends ElementsExplorerActions<ActionPattern> {
        private final PoshPlan plan;

        APExplorerActions(PoshPlan plan, Crawler<ActionPattern> refreshCrawler) {
            super(refreshCrawler);
            this.plan = plan;
        }

        @Override
        public String getNewItemLabel() {
            return "New action pattern (drag and drop)";
        }

        @Override
        public String getDescription(ActionPattern ap) {
            return ap.getHtmlDescription();
        }

        @Override
        public boolean delete(ActionPattern actionPattern) {
            boolean confirmed = PGSupport.confirm("Are you sure you want to delete action pattern " + actionPattern.getName());
            if (confirmed) {
                this.plan.removeActionPattern(actionPattern);
                return true;
            }
            return false;
        }

        @Override
        public Transferable createNewTransferable() {
            return new ExTransferable.Single(ActionPattern.dataFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    String name = PGSupport.getIdentifierFromDialog("Name of new action pattern.");
                    if (name == null) {
                        return null;
                    }
                    return LapElementsFactory.createActionPattern((String)name);
                }
            };
        }
    }

    static final class CompetenceExplorerActions
    extends ElementsExplorerActions<Competence> {
        private final PoshPlan plan;

        CompetenceExplorerActions(PoshPlan plan, Crawler<Competence> refreshCrawler) {
            super(refreshCrawler);
            this.plan = plan;
        }

        @Override
        public String getNewItemLabel() {
            return "New competence (drag and drop)";
        }

        @Override
        public String getDescription(Competence competence) {
            return competence.getHtmlDescription();
        }

        @Override
        public boolean delete(Competence competence) {
            boolean confirmed = PGSupport.confirm("Are you sure you want to delete competence " + competence.getName());
            if (confirmed) {
                this.plan.removeCompetence(competence);
                return true;
            }
            return false;
        }

        @Override
        public Transferable createNewTransferable() {
            return new ExTransferable.Single(Competence.dataFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    String competenceName = PGSupport.getIdentifierFromDialog("Name of competence");
                    if (competenceName == null) {
                        return null;
                    }
                    String elementName = PGSupport.getIdentifierFromDialog("Name of competence atom");
                    if (elementName == null) {
                        return null;
                    }
                    try {
                        return LapElementsFactory.createCompetence((String)competenceName, (String[])new String[]{elementName});
                    }
                    catch (DuplicateNameException ex) {
                        throw new FubarException("Creating new competence with only one name, what duplicate?", (Throwable)ex);
                    }
                }
            };
        }
    }

    static abstract class ElementsExplorerActions<T extends PoshElement>
    implements IExplorerActions<T> {
        private final Crawler<T> refreshCrawler;

        ElementsExplorerActions(Crawler<T> refreshCrawler) {
            this.refreshCrawler = refreshCrawler;
        }

        @Override
        public final String getDisplayName(T item) {
            return "<html><b>" + ((INamedElement)item).getName() + "</b></html>";
        }

        @Override
        public final boolean filter(String query, boolean caseSensitive, T item) {
            if (caseSensitive) {
                return !item.toString().contains(query);
            }
            return !item.toString().toLowerCase().contains(query.toLowerCase());
        }

        @Override
        public final void refresh(Explorer<T> explorer) {
            this.refreshCrawler.addListener(explorer);
            this.refreshCrawler.crawl();
        }

        @Override
        public final void openEditor(T item) {
        }

        @Override
        public final Transferable createTransferable(T data) {
            return new NodeTransferable<T>(data);
        }
    }

    private static abstract class PrimitiveWizardTransferable<PRIMITIVE>
    extends ExTransferable.Single {
        private final Project project;
        private final String templateFile;

        public PrimitiveWizardTransferable(DataFlavor flavor, Project project, String templateFile) {
            super(flavor);
            this.project = project;
            this.templateFile = templateFile;
        }

        abstract PRIMITIVE createPrimitive(String var1);

        protected Object getData() {
            FileObject template = FileUtil.getConfigFile((String)this.templateFile);
            NewPrimitiveWizardIterator iter = new NewPrimitiveWizardIterator();
            WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)iter);
            wd.putProperty("targetTemplate", (Object)template);
            wd.putProperty("project", (Object)this.project);
            iter.initialize(wd);
            Object dialogResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)wd);
            if (!dialogResult.equals(NotifyDescriptor.YES_OPTION)) {
                return null;
            }
            return this.createPrimitive(this.getNewClassFQN(wd));
        }

        private String getNewClassFQN(WizardDescriptor wd) {
            String className = Templates.getTargetName((WizardDescriptor)wd);
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wd);
            ClassPath targetFolderClasspath = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/source");
            String pkg = targetFolderClasspath.getResourceName(targetFolder, '.', false);
            if (!pkg.isEmpty()) {
                return pkg + '.' + className;
            }
            return className;
        }
    }

    static abstract class PrimitiveExplorerActions
    implements IExplorerActions<PrimitiveData> {
        private final Crawler<PrimitiveData> refreshCrawler;

        public PrimitiveExplorerActions(Crawler<PrimitiveData> refreshCrawler) {
            this.refreshCrawler = refreshCrawler;
        }

        @Override
        public final String getDisplayName(PrimitiveData primitive) {
            String displayName = primitive.name;
            if (displayName == null) {
                displayName = primitive.classFQN.replaceFirst("^.*\\.", "");
            }
            return "<html><b>" + displayName + "</b> (" + primitive.classFQN + ")</html>";
        }

        @Override
        public final String getDescription(PrimitiveData metadata) {
            return metadata.getHtmlDescription();
        }

        @Override
        public final boolean filter(String query, boolean caseSensitive, PrimitiveData metadata) {
            if (metadata.classFQN.contains(query)) {
                return false;
            }
            if (metadata.name != null && metadata.name.contains(query)) {
                return false;
            }
            for (String tag : metadata.tags) {
                if (!tag.contains(query)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final void refresh(Explorer<PrimitiveData> explorer) {
            this.refreshCrawler.addListener(explorer);
            this.refreshCrawler.crawl();
        }

        @Override
        public boolean delete(PrimitiveData item) {
            PGSupport.message("Primitives can't be deleted this way, you have to delete the class in the project and press refresh.");
            return false;
        }

        @Override
        public void openEditor(PrimitiveData metadata) {
            String javaFilePath = metadata.classFQN.replace('.', '/') + ".java";
            for (FileObject curRoot : GlobalPathRegistry.getDefault().getSourceRoots()) {
                EditorCookie ec;
                FileObject fileObject = curRoot.getFileObject(javaFilePath);
                if (fileObject == null) continue;
                DataObject dobj = null;
                try {
                    dobj = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (dobj == null || (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) == null) continue;
                ec.open();
            }
        }
    }

    static final class SensesExplorerActions
    extends PrimitiveExplorerActions {
        private final Project project;

        public SensesExplorerActions(Crawler<PrimitiveData> refreshCrawler, Project project) {
            super(refreshCrawler);
            this.project = project;
        }

        @Override
        public String getNewItemLabel() {
            return "New sense (drag and drop)";
        }

        @Override
        public Transferable createNewTransferable() {
            return new PrimitiveWizardTransferable(Sense.dataFlavor, this.project, "Templates/Classes/Sense.java"){

                Object createPrimitive(String FQN) {
                    return LapElementsFactory.createSense((String)FQN);
                }
            };
        }

        @Override
        public Transferable createTransferable(PrimitiveData data) {
            if (data == null) {
                return null;
            }
            String senseName = data.classFQN;
            return new NodeTransferable<Sense>(LapElementsFactory.createSense((String)senseName));
        }
    }

    static final class ActionsExplorerActions
    extends PrimitiveExplorerActions {
        private final Project project;

        public ActionsExplorerActions(Crawler<PrimitiveData> refreshCrawler, Project project) {
            super(refreshCrawler);
            this.project = project;
        }

        @Override
        public String getNewItemLabel() {
            return "New action (drag and drop)";
        }

        @Override
        public Transferable createNewTransferable() {
            return new PrimitiveWizardTransferable(TriggeredAction.dataFlavor, this.project, "Templates/Classes/Action.java"){

                Object createPrimitive(String FQN) {
                    return LapElementsFactory.createAction((String)FQN);
                }
            };
        }

        @Override
        public Transferable createTransferable(PrimitiveData data) {
            if (data == null) {
                return null;
            }
            String actionName = data.classFQN;
            return new NodeTransferable<TriggeredAction>(LapElementsFactory.createAction((String)actionName));
        }
    }
}

