/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableParameterTest
extends Assert {
    private VariableContext ctx;
    private TableParameter stringParameter;
    private TableParameter nilParameter;
    private TableParameter intParameter;
    private TableParameter boolParameter;
    private TableParameter overridenValue;

    @Before
    public void setUp() {
        this.ctx = new VariableContext();
        this.ctx.put("$variable", (Object)"\"value\"");
        this.overridenValue = new TableParameter("$overridenValueParam", "\"original\"", "\"overriden\"");
        this.stringParameter = new TableParameter("$stringParam", "\"Hello\"", "");
        this.nilParameter = new TableParameter("$nilParam", "nil", "");
        this.intParameter = new TableParameter("$intParam", "15", "");
        this.boolParameter = new TableParameter("$boolParam", "true", "");
    }

    @Test
    public void stringParam() {
        TableParameterTest.assertEquals((Object)"Hello", (Object)this.stringParameter.getDefaultValue());
    }

    @Test
    public void nilParam() {
        TableParameterTest.assertEquals(null, (Object)this.nilParameter.getDefaultValue());
    }

    @Test
    public void intParam() {
        TableParameterTest.assertEquals((Object)15, (Object)this.intParameter.getDefaultValue());
    }

    @Test
    public void boolParam() {
        TableParameterTest.assertEquals((Object)true, (Object)this.boolParameter.getDefaultValue());
    }

    @Test
    public void overridenValueParamArgument() {
        Arguments.Argument argument = this.overridenValue.createOverrideArgument(this.ctx);
        TableParameterTest.assertEquals((Object)"$overridenValueParam", (Object)argument.getName());
        TableParameterTest.assertNull((Object)argument.getParameterVariable());
        TableParameterTest.assertEquals((Object)"overriden", (Object)argument.getValue());
    }

    @Test
    public void overridenVariable() {
        TableParameter overridenVariable = new TableParameter("$overridenParam", "\"original\"", "$variable");
        Arguments.Argument argument = overridenVariable.createOverrideArgument(this.ctx);
        TableParameterTest.assertEquals((Object)"$overridenParam", (Object)argument.getName());
        TableParameterTest.assertEquals((Object)"$variable", (Object)argument.getParameterVariable());
    }

    @Test(expected=IllegalStateException.class)
    public void nonexistentOverridenVariable() {
        TableParameter overridenVariable = new TableParameter("$overridenParam", "\"original\"", "$nonexistent");
        overridenVariable.createOverrideArgument(this.ctx);
    }

    @Test(expected=IllegalStateException.class)
    public void unparsableOverridenValue() {
        TableParameter overridenVariable = new TableParameter("$overridenParam", "\"original\"", "wrong\" Syntax");
        overridenVariable.createOverrideArgument(this.ctx);
    }
}

