/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.pogamut.posh.PoshEditorSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class PoshDataObject
extends MultiDataObject
implements Lookup.Provider {
    final InstanceContent ic;
    private AbstractLookup lookup;
    private final PoshEditorSupport support;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            PoshDataObject.this.getEditorSupport().saveDocument();
        }
    };

    public PoshDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.support = new PoshEditorSupport(this);
        this.ic.add((Object)this.support);
        this.ic.add((Object)this);
    }

    protected Node createNodeDelegate() {
        DataNode dn = new DataNode((DataObject)this, Children.LEAF, this.getLookup());
        dn.setIconBaseWithExtension("cz/cuni/pogamut/posh/POSH_icon.png");
        return dn;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        return (T)((Node.Cookie)this.lookup.lookup(type));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public PoshEditorSupport getEditorSupport() {
        return this.support;
    }

    public void setModified(boolean modif) {
        super.setModified(modif);
        if (modif) {
            if (this.getCookie(SaveCookie.class) == null) {
                this.getCookieSet().add((Node.Cookie)this.saveCookie);
            }
        } else if (this.saveCookie.equals(this.getCookie(SaveCookie.class))) {
            this.getCookieSet().remove((Node.Cookie)this.saveCookie);
        }
    }

    public PoshPlan parseLapPlan() throws ParseException {
        StyledDocument doc = this.getEditorSupport().getDocument();
        GetDocumentText getText = new GetDocumentText(doc);
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)getText);
        String lapPlan = getText.text;
        PoshParser parser = new PoshParser((Reader)new StringReader(lapPlan));
        return parser.parsePlan();
    }

    private static class GetDocumentText
    implements Runnable {
        private StyledDocument doc;
        private String text;

        public GetDocumentText(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                this.text = this.doc.getText(0, this.doc.getLength());
            }
            catch (BadLocationException ex) {
                throw new FubarException("I should have an exclusive access to doc.", (Throwable)ex);
            }
        }
    }
}

