package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ArgumentsTableModel extends AbstractTableModel {

    /**
     * All arguments in the table.
     */
    private final List<TableArgument> arguments = new LinkedList<TableArgument>();
    private static final String[] columns = {"Argument name", "Value"};

    public ArgumentsTableModel(FormalParameters params, Arguments args) {
        // TODO: remove args used in params some other way, this doesn;t do any cheking
        for (Arguments.Argument arg : args) {
            String argName = arg.getParameterName();
            // ignore indexed (unnamed) arguments, only named are further considered.
            if (!argName.startsWith("$")) {
                continue;
            }
            // args used to override some parameter are ignored
            boolean argOverridesParam = false;
            for (FormalParameters.Parameter param : params) {
                String paramName = param.getName();
                if (paramName.equals(argName)) {
                    argOverridesParam = true;
                }
            }
            if (argOverridesParam) {
                continue;
            }

            arguments.add(new TableArgument(arg));
        }
    }

    @Override
    public int getRowCount() {
        return arguments.size();
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return arguments.get(rowIndex).getName();
        } else if (columnIndex == 1) {
            return arguments.get(rowIndex).getValueString();
        } else {
            throw new FubarException("Unexpected column index " + columnIndex);
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TableArgument argument = arguments.get(rowIndex);

        String valueString = (String) value;
        if (columnIndex == 0) {
            argument.setName(valueString);
        } else if (columnIndex == 1) {
            try {
                argument.setValueString(valueString);
            } catch (ParseException ex) {
                return;
            }
        } else {
            throw new FubarException("Unexpected position " + rowIndex + " " + columnIndex);
        }
        fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void deleteArgument(int deleteIndex) {
        arguments.remove(deleteIndex);
        fireTableRowsDeleted(deleteIndex, deleteIndex);
    }

    /**
     * Add new parameter.
     *
     * @param addIndex Index at which should be new parameter added
     * @param argName Name of new parameter
     * @param value Object value of parameter
     */
    public void addArgument(int addIndex, String argName, Object value) {
        TableArgument newVariable = new TableArgument(argName, value);
        arguments.add(addIndex, newVariable);
        fireTableDataChanged();
    }

    /**
     * @return unmodifiable collection of argfuments of this model.
     */
    public List<TableArgument> getArguments() {
        return Collections.unmodifiableList(arguments);
    }
}
