package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import java.awt.Dimension;
import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Widget;

/**
 * This envelope is containing the {@link Trigger trigger} {@link Sense senses}.
 * It can add/move/delete {@link ShedSenseWidget}.
 * <p/>
 * The origin of the envelope ([0,0]) is at left top corner, its height is {@link ShedWidget#height}
 * and its width is width of its children + {@link ShedWidgetFactory#HORIZONTAL_GAP}
 * between each widget.
 *
 * @author HonzaH
 */
public class ShedTriggerEnvelope extends AbstractShedEnvelope<ShedSenseWidget> implements IAnchorProvider {

    /**
     * Anchor used as source for connections between the widgets.
     */
    private final Anchor anchor;

    /**
     * Create envelope for the trigger senses. The @anchor is can used as source
     * anchor for {@link ArrowWidget}s, through {@link #getCommonAnchor() }.
     *
     * @param scene
     * @param anchor
     */
    public ShedTriggerEnvelope(ShedScene scene, Anchor anchor) {
        super(scene);
        setMinimumSize(new Dimension(0, ShedWidget.height));
        this.anchor = anchor;
    }

    /**
     * Create envelope for trigger senses.
     *
     * @param scene
     */
    public ShedTriggerEnvelope(ShedScene scene) {
        super(scene);
        setMinimumSize(new Dimension(0, ShedWidget.height));
        this.anchor = new FixedWidgetAnchor(this, new Point(ShedWidget.width / 2, ShedWidget.height), Anchor.Direction.RIGHT);
    }

    @Override
    public void updateChildrenPositions() {
        int currentX = 0;
        int currentY = 0;

        for (int childIndex = 0; childIndex < numberOfChildren(); ++childIndex) {
            ShedSenseWidget child = getChild(childIndex);
            child.setPreferredLocation(new Point(currentX, currentY));
            currentX += ShedWidget.width + ShedWidgetFactory.HORIZONTAL_GAP;
        }
    }

    @Override
    public Anchor getCommonAnchor() {
        return anchor;
    }
}
